/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.navigator.internal;

import com.google.inject.Inject;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.n4js.ui.navigator.internal.SelectTopLevelElementActionGroup;
import org.eclipse.n4js.ui.navigator.internal.SelectWorkingSetDropDownAction;
import org.eclipse.n4js.ui.navigator.internal.ShowHiddenWorkingSetsDropDownAction;
import org.eclipse.n4js.ui.workingsets.TopLevelElementChangedListener;
import org.eclipse.n4js.ui.workingsets.WorkingSet;
import org.eclipse.n4js.ui.workingsets.WorkingSetManager;
import org.eclipse.n4js.ui.workingsets.WorkingSetManagerBroker;
import org.eclipse.n4js.ui.workingsets.WorkingSetManagerStateChangedListener;
import org.eclipse.n4js.utils.Diff;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.navigator.resources.actions.WorkingSetActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

public class N4JSActionBarContributionProvider
extends WorkingSetActionProvider
implements TopLevelElementChangedListener,
WorkingSetManagerStateChangedListener {
    @Inject
    private SelectWorkingSetDropDownAction selectWorkingSetAction;
    @Inject
    private SelectTopLevelElementActionGroup selectTopLevelElementAction;
    @Inject
    private ShowHiddenWorkingSetsDropDownAction showHiddenWorkingSetsAction;
    @Inject
    private WorkingSetManagerBroker workingSetManagerBroker;
    private IActionBars actionBars;
    private boolean alreadyContributedToViewer;
    private ActionContributionItem selectWorkingSetDelegate;
    private ActionContributionItem showHiddenWorkingSetsDelegate;

    public void init(ICommonActionExtensionSite site) {
        this.selectWorkingSetDelegate = new ActionContributionItem((IAction)this.selectWorkingSetAction);
        this.showHiddenWorkingSetsDelegate = new ActionContributionItem((IAction)this.showHiddenWorkingSetsAction);
        this.workingSetManagerBroker.addTopLevelElementChangedListener(this);
        this.workingSetManagerBroker.addWorkingSetManagerStateChangedListener(this);
    }

    public void fillActionBars(IActionBars actionBars) {
        if (!this.alreadyContributedToViewer) {
            this.actionBars = actionBars;
            try {
                this.topLevelElementChanged(this.workingSetManagerBroker.isWorkingSetTopLevel());
            }
            finally {
                this.alreadyContributedToViewer = true;
            }
        }
    }

    public void fillContextMenu(IMenuManager menu) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public void dispose() {
        if (this.selectWorkingSetAction != null) {
            this.selectWorkingSetAction.dispose();
        }
        this.workingSetManagerBroker.removeTopLevelElementChangedListener(this);
    }

    @Override
    public void topLevelElementChanged(boolean workingSetTopLevel) {
        if (this.actionBars != null) {
            IToolBarManager toolBarManager = this.actionBars.getToolBarManager();
            toolBarManager.remove((IContributionItem)this.selectWorkingSetDelegate);
            toolBarManager.remove((IContributionItem)this.showHiddenWorkingSetsDelegate);
            if (this.workingSetManagerBroker.isWorkingSetTopLevel()) {
                toolBarManager.add((IContributionItem)this.selectWorkingSetDelegate);
                WorkingSetManager manager = this.workingSetManagerBroker.getActiveManager();
                if (manager != null) {
                    WorkingSet[] allItems = manager.getAllWorkingSets();
                    WorkingSet[] items = manager.getWorkingSets();
                    this.updateShowHiddenAction(allItems, items);
                }
            }
            this.selectTopLevelElementAction.fillActionBars(this.actionBars);
            this.actionBars.updateActionBars();
        }
    }

    @Override
    public void workingSetManagerStateChanged(WorkingSetManagerStateChangedListener.WorkingSetManagerChangeEvent event) {
        Diff<WorkingSet> diff = event.getDiff();
        WorkingSetManager activeManager = this.workingSetManagerBroker.getActiveManager();
        String changedId = event.getId();
        if (this.actionBars != null && activeManager != null && !diff.isEmpty() && this.workingSetManagerBroker.isWorkingSetTopLevel() && activeManager.getId().equals(changedId)) {
            WorkingSet[] allItems = (WorkingSet[])diff.getNewAllItems();
            WorkingSet[] items = (WorkingSet[])diff.getNewItems();
            this.updateShowHiddenAction(allItems, items);
            this.actionBars.updateActionBars();
        }
    }

    private void updateShowHiddenAction(WorkingSet[] allItems, WorkingSet[] items) {
        IToolBarManager toolBarManager = this.actionBars.getToolBarManager();
        toolBarManager.remove((IContributionItem)this.showHiddenWorkingSetsDelegate);
        if (allItems.length > items.length) {
            toolBarManager.add((IContributionItem)this.showHiddenWorkingSetsDelegate);
        }
    }
}

