/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.proposals.imports;

import com.google.common.base.Predicate;
import com.google.inject.Inject;
import com.google.inject.MembersInjector;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.scoping.imports.PlainAccessOfAliasedImportDescription;
import org.eclipse.n4js.scoping.imports.PlainAccessOfNamespacedImportDescription;
import org.eclipse.n4js.ts.scoping.N4TSQualifiedNameProvider;
import org.eclipse.n4js.ts.types.ModuleNamespaceVirtualType;
import org.eclipse.n4js.ui.proposals.imports.AliasLocation;
import org.eclipse.n4js.ui.proposals.imports.ImportRewriter;
import org.eclipse.n4js.ui.proposals.linkedEditing.IdentifierExitPolicy;
import org.eclipse.n4js.ui.proposals.linkedEditing.N4JSCompletionProposal;
import org.eclipse.n4js.ui.utils.ConfigurableCompletionProposalExtensions;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.n4js.utils.UtilN4;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ReplacementTextApplier;

public class N4JSReplacementTextApplier
extends ReplacementTextApplier {
    public static final String KEY_QUALIFIED_NAME = String.valueOf(N4JSReplacementTextApplier.class.getName()) + "#QUALIFIED_NAME";
    public static final String KEY_ORIGINAL_QUALIFIED_NAME = String.valueOf(N4JSReplacementTextApplier.class.getName()) + "#ORIGINAL_QUALIFIED_NAME";
    private static final Logger logger = Logger.getLogger(N4JSReplacementTextApplier.class);
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private ImportRewriter.Factory importRewriterFactory;
    @Inject
    IN4JSCore n4jsCore;
    private final IScope scope;
    private final Resource context;
    private final IValueConverter<String> valueConverter;
    private final Predicate<IEObjectDescription> filter;
    private final ITextViewer viewer;

    N4JSReplacementTextApplier(Resource context, IScope scope, IValueConverter<String> valueConverter, Predicate<IEObjectDescription> filter, ITextViewer viewer) {
        this.context = context;
        this.scope = scope;
        this.valueConverter = valueConverter;
        this.filter = filter;
        this.viewer = viewer;
    }

    private String applyValueConverter(QualifiedName qualifiedName) {
        String result = this.qualifiedNameConverter.toString(qualifiedName);
        result = this.valueConverter.toString((Object)result);
        return result;
    }

    private QualifiedName applyValueConverter(String concreteSyntax) {
        String semanticReplacementString = (String)this.valueConverter.toValue(concreteSyntax, null);
        QualifiedName qualifiedName = this.qualifiedNameConverter.toQualifiedName(semanticReplacementString);
        return qualifiedName;
    }

    public String getActualReplacementString(ConfigurableCompletionProposal proposal) {
        String syntacticReplacementString = proposal.getReplacementString();
        if (this.scope != null) {
            IEObjectDescription description;
            EObject resolved;
            QualifiedName qualifiedName = this.applyValueConverter(syntacticReplacementString);
            if (qualifiedName.getSegmentCount() == 1) {
                return syntacticReplacementString;
            }
            IEObjectDescription element = this.scope.getSingleElement(qualifiedName);
            if (element != null && !(resolved = EcoreUtil.resolve((EObject)element.getEObjectOrProxy(), (Resource)this.context)).eIsProxy() && (description = this.findApplicableDescription(resolved, qualifiedName, true)) != null) {
                String multisegmentProposal = this.applyValueConverter(description.getName());
                return multisegmentProposal;
            }
        }
        return syntacticReplacementString;
    }

    private IEObjectDescription findApplicableDescription(EObject objectOrProxy, QualifiedName qualifiedName, boolean simpleNameMatch) {
        Iterable lookupElements = this.scope.getElements(objectOrProxy);
        for (IEObjectDescription lookupElement : lookupElements) {
            if (!this.filter.apply((Object)lookupElement) || simpleNameMatch != qualifiedName.getLastSegment().equals(lookupElement.getName().getLastSegment())) continue;
            return lookupElement;
        }
        return null;
    }

    public void apply(IDocument document, ConfigurableCompletionProposal proposal) throws BadLocationException {
        QualifiedName shortQualifiedName;
        String actualSyntacticReplacementString;
        String syntacticReplacementString = proposal.getReplacementString();
        if (!syntacticReplacementString.equals(actualSyntacticReplacementString = this.getActualReplacementString(proposal)) && (shortQualifiedName = this.applyValueConverter(actualSyntacticReplacementString)).getSegmentCount() == 1) {
            this.simpleApply(document, actualSyntacticReplacementString, proposal);
            return;
        }
        QualifiedName qualifiedName = (QualifiedName)proposal.getAdditionalData(KEY_QUALIFIED_NAME);
        QualifiedName originalQualifiedName = (QualifiedName)proposal.getAdditionalData(KEY_ORIGINAL_QUALIFIED_NAME);
        if (qualifiedName == null) {
            this.simpleApply(document, syntacticReplacementString, proposal);
            return;
        }
        if (qualifiedName.getSegmentCount() == 1) {
            this.simpleApply(document, syntacticReplacementString, proposal);
            return;
        }
        if (qualifiedName.getSegmentCount() == 2 && N4TSQualifiedNameProvider.GLOBAL_NAMESPACE_SEGMENT.equals(qualifiedName.getFirstSegment())) {
            this.simpleApply(document, syntacticReplacementString, proposal);
            return;
        }
        String alias = null;
        String shortQName = N4JSLanguageUtils.lastSegmentOrDefaultHost((QualifiedName)originalQualifiedName);
        IEObjectDescription descriptionFullQN = this.scope.getSingleElement(QualifiedName.create((String)shortQName));
        if (descriptionFullQN instanceof PlainAccessOfNamespacedImportDescription) {
            this.simpleApply(document, ((PlainAccessOfNamespacedImportDescription)descriptionFullQN).getNamespacedName(), proposal);
            return;
        }
        if (descriptionFullQN instanceof PlainAccessOfAliasedImportDescription) {
            this.simpleApply(document, ((PlainAccessOfAliasedImportDescription)descriptionFullQN).getAlias(), proposal);
            return;
        }
        if (descriptionFullQN != null) {
            if (descriptionFullQN.getEObjectOrProxy() instanceof ModuleNamespaceVirtualType) {
                this.simpleApply(document, qualifiedName.toString(), proposal);
                return;
            }
            alias = "Alias" + UtilN4.toUpperCaseFirst((String)shortQName);
        }
        this.applyWithImport(qualifiedName, alias, document, proposal);
    }

    private void simpleApply(IDocument document, String string, ConfigurableCompletionProposal proposal) throws BadLocationException {
        String replacement = String.valueOf(string) + ConfigurableCompletionProposalExtensions.getReplacementSuffix(proposal);
        proposal.setCursorPosition(replacement.length());
        document.replace(proposal.getReplacementOffset(), proposal.getReplacementLength(), replacement);
        this.adjustCursorPositionIfRequested(proposal);
    }

    private void applyWithImport(QualifiedName qualifiedName, String alias, IDocument document, ConfigurableCompletionProposal proposal) throws BadLocationException {
        int topPixel = -1;
        StyledText widget = this.viewer.getTextWidget();
        if (widget != null) {
            topPixel = widget.getTopPixel();
        }
        ITextViewerExtension viewerExtension = null;
        if (this.viewer instanceof ITextViewerExtension) {
            viewerExtension = (ITextViewerExtension)this.viewer;
            viewerExtension.setRedraw(false);
        }
        DocumentRewriteSession rewriteSession = null;
        try {
            if (document instanceof IDocumentExtension4) {
                rewriteSession = ((IDocumentExtension4)document).startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED_SMALL);
            }
            int initialCursorLine = document.getLineOfOffset(proposal.getReplacementOffset());
            int newCursorPositionInDocument = this.doApply(qualifiedName, alias, document, proposal);
            int newCursorLine = document.getLineOfOffset(newCursorPositionInDocument);
            if (widget != null) {
                int additionalTopPixel = (newCursorLine - initialCursorLine) * widget.getLineHeight();
                widget.setTopPixel(topPixel + additionalTopPixel);
            }
        }
        finally {
            if (rewriteSession != null) {
                ((IDocumentExtension4)document).stopRewriteSession(rewriteSession);
            }
            if (viewerExtension != null) {
                viewerExtension.setRedraw(true);
            }
        }
    }

    private int doApply(QualifiedName qualifiedName, String alias, IDocument document, ConfigurableCompletionProposal proposal) throws BadLocationException {
        String shortSemanticReplacementString = alias != null ? alias : N4JSLanguageUtils.lastSegmentOrDefaultHost((QualifiedName)qualifiedName);
        String shortSyntacticReplacementString = this.valueConverter.toString((Object)shortSemanticReplacementString);
        String longReplacementString = String.valueOf(shortSyntacticReplacementString) + ConfigurableCompletionProposalExtensions.getReplacementSuffix(proposal);
        ImportRewriter importRewriter = this.importRewriterFactory.create(document, this.context);
        ReplaceEdit replaceEdit = new ReplaceEdit(proposal.getReplacementOffset(), proposal.getReplacementLength(), longReplacementString);
        MultiTextEdit compound = new MultiTextEdit();
        AliasLocation aliasLocation = null;
        if (alias != null) {
            aliasLocation = importRewriter.addSingleImport(qualifiedName, alias, compound);
        } else {
            importRewriter.addSingleImport(qualifiedName, compound);
        }
        compound.addChild((TextEdit)replaceEdit);
        Position caret = new Position(proposal.getReplacementOffset(), 0);
        document.addPosition(caret);
        compound.apply(document);
        document.removePosition(caret);
        int cursorPosition = caret.getOffset();
        proposal.setReplacementOffset(cursorPosition - longReplacementString.length());
        proposal.setReplacementLength(shortSyntacticReplacementString.length());
        proposal.setCursorPosition(cursorPosition - proposal.getReplacementOffset());
        if (aliasLocation != null) {
            int aliasOffset = aliasLocation.getBaseOffset() + aliasLocation.getRelativeOffset();
            int aliasLength = shortSyntacticReplacementString.length();
            N4JSCompletionProposal castedProposal = (N4JSCompletionProposal)proposal;
            castedProposal.setLinkedModeBuilder((appliedProposal, currentDocument) -> {
                if (this.viewer.getTextWidget() == null || this.viewer.getTextWidget().isDisposed()) {
                    return;
                }
                try {
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    group.addPosition(new LinkedPosition(currentDocument, aliasOffset, aliasLength, -1));
                    group.addPosition(new LinkedPosition(currentDocument, proposal.getReplacementOffset(), proposal.getReplacementLength(), -1));
                    proposal.setSelectionStart(proposal.getReplacementOffset());
                    proposal.setSelectionLength(proposal.getReplacementLength());
                    LinkedModeModel model = new LinkedModeModel();
                    model.addGroup(group);
                    model.forceInstall();
                    LinkedModeUI ui = new LinkedModeUI(model, this.viewer);
                    ui.setExitPolicy((LinkedModeUI.IExitPolicy)new IdentifierExitPolicy('\n'));
                    ui.setExitPosition(this.viewer, proposal.getReplacementOffset() + proposal.getCursorPosition() + ConfigurableCompletionProposalExtensions.getCursorOffset(proposal), 0, Integer.MAX_VALUE);
                    ui.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
                    ui.enter();
                }
                catch (BadLocationException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            });
        } else {
            this.adjustCursorPositionIfRequested(proposal);
        }
        return cursorPosition;
    }

    private void adjustCursorPositionIfRequested(ConfigurableCompletionProposal proposal) {
        int offset = ConfigurableCompletionProposalExtensions.getCursorOffset(proposal);
        if (offset != 0) {
            proposal.setCursorPosition(proposal.getCursorPosition() + offset);
            if (this.viewer.getTextWidget() != null && !this.viewer.getTextWidget().isDisposed()) {
                int pos = proposal.getReplacementOffset() + proposal.getCursorPosition();
                proposal.setSelectionStart(pos);
                proposal.setSelectionLength(0);
                proposal.setSimpleLinkedMode(this.viewer, new char[]{'\t', '\n', '\r'});
            }
        }
    }

    public static class Factory {
        @Inject
        private MembersInjector<N4JSReplacementTextApplier> applierInjector;

        public N4JSReplacementTextApplier create(Resource context, IScope scope, IValueConverter<String> valueConverter, Predicate<IEObjectDescription> filter, ITextViewer viewer) {
            N4JSReplacementTextApplier result = new N4JSReplacementTextApplier(context, scope, valueConverter, filter, viewer);
            this.applierInjector.injectMembers((Object)result);
            return result;
        }
    }
}

