/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc.tags;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.n4js.jsdoc.ITagDefinition;
import org.eclipse.n4js.jsdoc.JSDocToken;
import org.eclipse.n4js.jsdoc.JSDocUtils;
import org.eclipse.n4js.jsdoc.dom.ContentNode;
import org.eclipse.n4js.jsdoc.dom.DomFactory;
import org.eclipse.n4js.jsdoc.dom.Tag;
import org.eclipse.n4js.jsdoc.dom.TagValue;
import org.eclipse.n4js.jsdoc.dom.Text;

public abstract class AbstractBaseTagDefinition
implements ITagDefinition {
    protected static final DomFactory DOM = DomFactory.eINSTANCE;
    protected List<String> titles;

    public void setTitles(String ... titles) {
        this.titles = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(titles)));
    }

    @Override
    public String getTitle() {
        return this.titles.get(0);
    }

    @Override
    public List<String> getAllTitles() {
        return this.titles;
    }

    @Override
    public void validate() {
    }

    protected TagValue addValue(Tag tag, String key, ContentNode contents) {
        return this.addValue(tag, key, Collections.singleton(contents));
    }

    protected TagValue addValue(Tag tag, String key, Collection<? extends ContentNode> contents) {
        TagValue tagValue = DOM.createTagValue();
        tagValue.setKey(key);
        tagValue.setBegin(JSDocUtils.getBegin(contents));
        tagValue.setEnd(JSDocUtils.getEnd(contents));
        tagValue.getContents().addAll(contents);
        tag.getValues().add((Object)tagValue);
        return tagValue;
    }

    protected TagValue addValue(Tag tag, String key, JSDocToken token) {
        Text text = DOM.createText();
        text.setText(token.token);
        text.setBegin(token.start);
        text.setEnd(token.end);
        return this.addValue(tag, key, text);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.getTitle();
    }
}

