/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.conversion;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.n4js.conversion.N4JSValueConverterWithValueException;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;
import org.eclipse.xtext.util.Strings;

public class CompositeSyntaxErrorMessages {
    private static final String CODE = CompositeSyntaxErrorMessages.class.getName();

    public static SyntaxErrorMessage toSyntaxErrorMessage(N4JSValueConverterWithValueException vce, Function<? super N4JSValueConverterWithValueException, ? extends SyntaxErrorMessage> delegate) {
        if (vce.getSuppressed().length == 0) {
            return delegate.apply(vce);
        }
        ArrayList<String> encoded = new ArrayList<String>();
        SyntaxErrorMessage first = delegate.apply(vce);
        CompositeSyntaxErrorMessages.encode(first, encoded);
        Throwable[] throwableArray = vce.getSuppressed();
        int n = throwableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Throwable t = throwableArray[n2];
            if (t instanceof N4JSValueConverterWithValueException) {
                SyntaxErrorMessage next = delegate.apply((N4JSValueConverterWithValueException)((Object)t));
                CompositeSyntaxErrorMessages.encode(next, encoded);
            }
            ++n2;
        }
        return new SyntaxErrorMessage(first.getMessage(), CODE, (String[])encoded.toArray(String[]::new));
    }

    private static void encode(SyntaxErrorMessage message, List<String> result) {
        result.add(message.getMessage());
        result.add(message.getIssueCode());
        String[] issueData = message.getIssueData();
        if (issueData != null && issueData.length > 0) {
            result.add(Strings.pack((String[])issueData));
        } else {
            result.add("");
        }
    }

    public static void toDiagnostic(SyntaxErrorMessage syntaxErrorMessage, Consumer<? super SyntaxErrorMessage> delegate) {
        if (CODE.equals(syntaxErrorMessage.getIssueCode())) {
            String[] encodedMessages = syntaxErrorMessage.getIssueData();
            int messageIndex = 0;
            while (messageIndex < encodedMessages.length) {
                String message = encodedMessages[messageIndex];
                String issueCode = encodedMessages[messageIndex + 1];
                String encodedIssueData = encodedMessages[messageIndex + 2];
                String[] issueData = "".equals(encodedIssueData) ? null : Strings.unpack((String)encodedIssueData);
                delegate.accept((SyntaxErrorMessage)new SyntaxErrorMessage(message, issueCode, issueData));
                messageIndex += 3;
            }
        } else {
            delegate.accept((SyntaxErrorMessage)syntaxErrorMessage);
        }
    }
}

