/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.packagejson;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.n4js.json.JSON.JSONDocument;
import org.eclipse.n4js.json.JSON.JSONObject;
import org.eclipse.n4js.json.JSON.JSONValue;
import org.eclipse.n4js.json.JSON.NameValuePair;
import org.eclipse.n4js.json.model.utils.JSONModelUtils;
import org.eclipse.n4js.packagejson.LazyParsingProjectDependencyImpl;
import org.eclipse.n4js.packagejson.LazyParsingProjectDescriptionImpl;
import org.eclipse.n4js.packagejson.PackageJsonProperties;
import org.eclipse.n4js.packagejson.PackageJsonUtils;
import org.eclipse.n4js.projectDescription.DependencyType;
import org.eclipse.n4js.projectDescription.ProjectDependency;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.projectDescription.ProjectDescriptionFactory;
import org.eclipse.n4js.projectDescription.SourceContainerDescription;
import org.eclipse.n4js.projectDescription.SourceContainerType;
import org.eclipse.n4js.semver.SemverHelper;
import org.eclipse.n4js.utils.ProjectDescriptionUtils;

public class PackageJsonHelper {
    @Inject
    private SemverHelper semverHelper;

    public ProjectDescription convertToProjectDescription(JSONDocument packageJSON, boolean applyDefaultValues, String defaultProjectName) {
        JSONValue rootValue = packageJSON.getContent();
        if (rootValue instanceof JSONObject) {
            LazyParsingProjectDescriptionImpl result = new LazyParsingProjectDescriptionImpl();
            EList rootPairs = ((JSONObject)rootValue).getNameValuePairs();
            this.convertRootPairs(result, (List<NameValuePair>)rootPairs);
            JSONValue property = JSONModelUtils.getProperty((JSONObject)((JSONObject)rootValue), (String)PackageJsonProperties.MAIN.name).orElse(null);
            String propertyAsString = JSONModelUtils.asNonEmptyStringOrNull((JSONValue)property);
            this.adjustProjectDescriptionAfterConversion(result, applyDefaultValues, defaultProjectName, propertyAsString);
            return result;
        }
        return null;
    }

    private void convertRootPairs(LazyParsingProjectDescriptionImpl target, List<NameValuePair> rootPairs) {
        for (NameValuePair pair : rootPairs) {
            String name = pair.getName();
            PackageJsonProperties property = PackageJsonProperties.valueOfNameOrNull(name);
            if (property == null) continue;
            JSONValue value = pair.getValue();
            switch (property) {
                case NAME: {
                    target.setProjectName(JSONModelUtils.asNonEmptyStringOrNull((JSONValue)value));
                    break;
                }
                case VERSION: {
                    target.setLazyProjectVersion(this.semverHelper, JSONModelUtils.asNonEmptyStringOrNull((JSONValue)value));
                    break;
                }
                case DEPENDENCIES: {
                    this.convertDependencies((ProjectDescription)target, JSONModelUtils.asNameValuePairsOrEmpty((JSONValue)value), true, DependencyType.RUNTIME);
                    break;
                }
                case DEV_DEPENDENCIES: {
                    this.convertDependencies((ProjectDescription)target, JSONModelUtils.asNameValuePairsOrEmpty((JSONValue)value), true, DependencyType.DEVELOPMENT);
                    break;
                }
                case MAIN: {
                    break;
                }
                case N4JS: {
                    target.setHasN4JSNature(true);
                    this.convertN4jsPairs((ProjectDescription)target, JSONModelUtils.asNameValuePairsOrEmpty((JSONValue)value));
                    break;
                }
                case WORKSPACES: {
                    target.setYarnWorkspaceRoot(true);
                    target.getWorkspaces().addAll((Collection)JSONModelUtils.asStringsInArrayOrEmpty((JSONValue)value));
                    break;
                }
            }
        }
    }

    private void convertN4jsPairs(ProjectDescription target, List<NameValuePair> n4jsPairs) {
        for (NameValuePair pair : n4jsPairs) {
            String name = pair.getName();
            PackageJsonProperties property = PackageJsonProperties.valueOfNameOrNull(name);
            if (property == null) continue;
            JSONValue value = pair.getValue();
            switch (property) {
                case PROJECT_TYPE: {
                    target.setProjectType(PackageJsonUtils.parseProjectType(JSONModelUtils.asNonEmptyStringOrNull((JSONValue)value)));
                    break;
                }
                case VENDOR_ID: {
                    target.setVendorId(JSONModelUtils.asNonEmptyStringOrNull((JSONValue)value));
                    break;
                }
                case VENDOR_NAME: {
                    target.setVendorName(JSONModelUtils.asNonEmptyStringOrNull((JSONValue)value));
                    break;
                }
                case OUTPUT: {
                    target.setOutputPath(JSONModelUtils.asNonEmptyStringOrNull((JSONValue)value));
                    break;
                }
                case SOURCES: {
                    target.getSourceContainers().addAll(PackageJsonUtils.asSourceContainerDescriptionsOrEmpty(value));
                    break;
                }
                case MODULE_FILTERS: {
                    target.getModuleFilters().addAll(PackageJsonUtils.asModuleFiltersInObjectOrEmpty(value));
                    break;
                }
                case MAIN_MODULE: {
                    target.setMainModule(JSONModelUtils.asNonEmptyStringOrNull((JSONValue)value));
                    break;
                }
                case TESTED_PROJECTS: {
                    target.getTestedProjects().addAll(PackageJsonUtils.asProjectReferencesInArrayOrEmpty(value));
                    break;
                }
                case IMPLEMENTATION_ID: {
                    target.setImplementationId(JSONModelUtils.asNonEmptyStringOrNull((JSONValue)value));
                    break;
                }
                case IMPLEMENTED_PROJECTS: {
                    target.getImplementedProjects().addAll(PackageJsonUtils.asProjectReferencesInArrayOrEmpty(value));
                    break;
                }
                case EXTENDED_RUNTIME_ENVIRONMENT: {
                    target.setExtendedRuntimeEnvironment(PackageJsonUtils.asProjectReferenceOrNull(value));
                    break;
                }
                case PROVIDED_RUNTIME_LIBRARIES: {
                    target.getProvidedRuntimeLibraries().addAll(PackageJsonUtils.asProjectReferencesInArrayOrEmpty(value));
                    break;
                }
                case REQUIRED_RUNTIME_LIBRARIES: {
                    target.getRequiredRuntimeLibraries().addAll(PackageJsonUtils.asProjectReferencesInArrayOrEmpty(value));
                    break;
                }
                case DEFINES_PACKAGE: {
                    target.setDefinesPackage(JSONModelUtils.asStringOrNull((JSONValue)value));
                    break;
                }
            }
        }
    }

    private void convertDependencies(ProjectDescription target, List<NameValuePair> depPairs, boolean avoidDuplicates, DependencyType type) {
        HashSet<String> existingProjectNames = new HashSet<String>();
        if (avoidDuplicates) {
            for (ProjectDependency pd : target.getProjectDependencies()) {
                existingProjectNames.add(pd.getProjectName());
            }
        }
        for (NameValuePair pair : depPairs) {
            String projectName = pair.getName();
            boolean addProjectDependency = true;
            addProjectDependency &= projectName != null && !projectName.isEmpty();
            boolean bl = !avoidDuplicates || !existingProjectNames.contains(projectName);
            existingProjectNames.add(projectName);
            if (!(addProjectDependency &= bl)) continue;
            JSONValue value = pair.getValue();
            String valueStr = JSONModelUtils.asStringOrNull((JSONValue)value);
            LazyParsingProjectDependencyImpl dep = new LazyParsingProjectDependencyImpl();
            dep.setProjectName(projectName);
            dep.setLazyVersionRequirement(this.semverHelper, valueStr);
            dep.setType(type);
            target.getProjectDependencies().add((Object)dep);
        }
    }

    private void adjustProjectDescriptionAfterConversion(LazyParsingProjectDescriptionImpl target, boolean applyDefaultValues, String defaultProjectName, String valueOfTopLevelPropertyMain) {
        List<String> sourceContainerPaths;
        String mainModulePath;
        boolean hasN4jsSpecificMainModule;
        boolean bl = hasN4jsSpecificMainModule = target.getMainModule() != null;
        if (applyDefaultValues) {
            this.applyDefaults(target, defaultProjectName);
        }
        if (valueOfTopLevelPropertyMain != null && !hasN4jsSpecificMainModule && (mainModulePath = ProjectDescriptionUtils.convertMainPathToModuleSpecifier(valueOfTopLevelPropertyMain, sourceContainerPaths = target.getSourceContainers().stream().flatMap(scd -> ProjectDescriptionUtils.getPathsNormalized(scd).stream()).collect(Collectors.toList()))) != null) {
            target.setMainModule(mainModulePath);
        }
        HashSet<String> projectNamesToRemove = new HashSet<String>();
        EList projectDependencies = target.getProjectDependencies();
        for (ProjectDependency dep : projectDependencies) {
            String otherProject = dep.getProjectName();
            if (!otherProject.endsWith(".api")) continue;
            projectNamesToRemove.add(otherProject.substring(0, otherProject.length() - ".api".length()));
        }
        if (!projectNamesToRemove.isEmpty()) {
            int i = projectDependencies.size() - 1;
            while (i >= 0) {
                if (projectNamesToRemove.contains(((ProjectDependency)projectDependencies.get(i)).getProjectName())) {
                    projectDependencies.remove(i);
                }
                --i;
            }
        }
    }

    private void applyDefaults(LazyParsingProjectDescriptionImpl target, String defaultProjectName) {
        if (!target.isHasN4JSNature()) {
            target.setProjectType(PackageJsonUtils.parseProjectType(PackageJsonProperties.PROJECT_TYPE.defaultValue));
        }
        if (target.getProjectName() == null) {
            target.setProjectName(defaultProjectName);
        }
        if (target.getLazyProjectVersion() == null) {
            target.setLazyProjectVersion(this.semverHelper, PackageJsonProperties.VERSION.defaultValue);
        }
        if (target.getVendorId() == null) {
            target.setVendorId(PackageJsonProperties.VENDOR_ID.defaultValue);
        }
        if (target.getMainModule() == null) {
            target.setMainModule(PackageJsonProperties.MAIN_MODULE.defaultValue);
        }
        if (target.getOutputPath() == null) {
            target.setOutputPath(PackageJsonProperties.OUTPUT.defaultValue);
        }
        if (target.isYarnWorkspaceRoot()) {
            return;
        }
        EList sourceContainers = target.getSourceContainers();
        SourceContainerDescription sourceContainerTypeSource = null;
        for (SourceContainerDescription sourceContainer : sourceContainers) {
            if (!sourceContainer.getPaths().isEmpty()) {
                return;
            }
            if (sourceContainerTypeSource != null || sourceContainer.getSourceContainerType() != SourceContainerType.SOURCE) continue;
            sourceContainerTypeSource = sourceContainer;
        }
        if (sourceContainerTypeSource == null) {
            sourceContainerTypeSource = ProjectDescriptionFactory.eINSTANCE.createSourceContainerDescription();
            sourceContainerTypeSource.setSourceContainerType(SourceContainerType.SOURCE);
            sourceContainers.add(sourceContainerTypeSource);
        }
        sourceContainerTypeSource.getPaths().add((Object)PackageJsonProperties.OUTPUT.defaultValue);
    }
}

