/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.analysis;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.n4js.flowgraphs.FlowAnalyser;
import org.eclipse.n4js.flowgraphs.N4JSFlowAnalyser;
import org.eclipse.n4js.flowgraphs.analysis.GraphVisitorGuideInternal;
import org.eclipse.n4js.flowgraphs.analysis.GraphVisitorInternal;
import org.eclipse.n4js.flowgraphs.analysis.TraverseDirection;
import org.eclipse.n4js.flowgraphs.dataflow.DataFlowVisitor;
import org.eclipse.n4js.flowgraphs.dataflow.DataFlowVisitorHost;
import org.eclipse.n4js.flowgraphs.model.ComplexNode;
import org.eclipse.n4js.flowgraphs.model.FlowGraph;
import org.eclipse.n4js.n4JS.ControlFlowElement;

public class GraphVisitorAnalysis {
    final N4JSFlowAnalyser flowAnalyzer;
    final FlowGraph cfg;
    private boolean forwardAnalysisDone = false;

    public GraphVisitorAnalysis(N4JSFlowAnalyser flowAnalyzer, FlowGraph cfg) {
        this.flowAnalyzer = flowAnalyzer;
        this.cfg = cfg;
    }

    public void forwardAnalysis(FlowAnalyser[] flowAnalysers) {
        if (this.forwardAnalysisDone) {
            throw new IllegalStateException("Forward analysis can be performed only once.");
        }
        List<GraphVisitorInternal> graphVisitors = this.getGraphVisitors(flowAnalysers, TraverseDirection.Forward);
        GraphVisitorGuideInternal guide = new GraphVisitorGuideInternal(this.flowAnalyzer, graphVisitors);
        guide.init();
        for (ControlFlowElement container : this.cfg.getAllContainers()) {
            ComplexNode cnContainer = this.cfg.getComplexNode(container);
            guide.walkthroughForward(cnContainer);
        }
        guide.terminate();
        this.forwardAnalysisDone = true;
    }

    public void backwardAnalysis(FlowAnalyser[] flowAnalysers) {
        if (!this.forwardAnalysisDone) {
            throw new IllegalStateException("Forward analysis must be performed first.");
        }
        List<GraphVisitorInternal> graphVisitors = this.getGraphVisitors(flowAnalysers, TraverseDirection.Backward);
        GraphVisitorGuideInternal guide = new GraphVisitorGuideInternal(this.flowAnalyzer, graphVisitors);
        guide.init();
        for (ControlFlowElement container : this.cfg.getAllContainers()) {
            ComplexNode cnContainer = this.cfg.getComplexNode(container);
            guide.walkthroughBackward(cnContainer);
        }
        guide.terminate();
    }

    private List<GraphVisitorInternal> getGraphVisitors(FlowAnalyser[] flowAnalysers, TraverseDirection direction) {
        LinkedList<GraphVisitorInternal> graphVisitors = new LinkedList<GraphVisitorInternal>();
        LinkedList<DataFlowVisitor> dataflowVisitorList = new LinkedList<DataFlowVisitor>();
        FlowAnalyser[] flowAnalyserArray = flowAnalysers;
        int n = flowAnalysers.length;
        int n2 = 0;
        while (n2 < n) {
            DataFlowVisitor dataflowVisitor;
            GraphVisitorInternal graphVisitor;
            FlowAnalyser flowAnalyser = flowAnalyserArray[n2];
            if (flowAnalyser instanceof GraphVisitorInternal && (graphVisitor = (GraphVisitorInternal)flowAnalyser).getDirection() == direction) {
                graphVisitors.add(graphVisitor);
            }
            if (flowAnalyser instanceof DataFlowVisitor && (dataflowVisitor = (DataFlowVisitor)flowAnalyser).getDirection() == direction) {
                dataflowVisitorList.add(dataflowVisitor);
            }
            ++n2;
        }
        if (!dataflowVisitorList.isEmpty()) {
            DataFlowVisitorHost dfvh = new DataFlowVisitorHost(direction, dataflowVisitorList);
            graphVisitors.add(dfvh);
        }
        return graphVisitors;
    }
}

