/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.analysers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.n4js.flowgraphs.analysis.GraphVisitor;
import org.eclipse.n4js.flowgraphs.analysis.TraverseDirection;
import org.eclipse.n4js.flowgraphs.dataflow.symbols.SymbolFactory;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TVariable;

public class UsedBeforeDeclaredAnalyserFastVersion
extends GraphVisitor {
    final Map<VariableDeclaration, Set<IdentifierRef>> checkLists = new HashMap<VariableDeclaration, Set<IdentifierRef>>();

    public UsedBeforeDeclaredAnalyserFastVersion() {
        super(TraverseDirection.Backward);
    }

    @Override
    protected void visit(ControlFlowElement cfe) {
        if (cfe instanceof VariableDeclaration) {
            this.checkLists.put((VariableDeclaration)cfe, new HashSet());
        }
        if (cfe instanceof IdentifierRef) {
            Set<IdentifierRef> refs;
            IdentifierRef ir = (IdentifierRef)cfe;
            IdentifiableElement id = SymbolFactory.getId(ir);
            if (id instanceof TVariable) {
                TVariable tvar = (TVariable)id;
                id = (VariableDeclaration)tvar.getAstElement();
            }
            if ((refs = this.checkLists.get(id)) != null) {
                refs.add(ir);
            }
        }
    }

    public List<IdentifierRef> getUsedButNotDeclaredIdentifierRefs() {
        LinkedList<IdentifierRef> idRefs = new LinkedList<IdentifierRef>();
        for (Set<IdentifierRef> refs : this.checkLists.values()) {
            idRefs.addAll(refs);
        }
        return idRefs;
    }
}

