/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.ui;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.n4js.N4JSGlobals;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.runner.ui.IDERunnerDelegate;
import org.eclipse.n4js.tester.TestConfiguration;
import org.eclipse.n4js.tester.ui.TestConfigurationConverter;
import org.eclipse.n4js.tester.ui.TesterFrontEndUI;
import org.eclipse.n4js.utils.StatusHelper;

public abstract class AbstractTesterLaunchConfigurationDelegate
extends IDERunnerDelegate {
    private static final Logger LOGGER = Logger.getLogger(AbstractTesterLaunchConfigurationDelegate.class);
    @Inject
    private TesterFrontEndUI testerFrontEndUI;
    @Inject
    private TestConfigurationConverter testConfigurationConverter;
    @Inject
    private StatusHelper statusHelper;
    @Inject
    private IN4JSCore n4jsCore;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IN4JSProject n4jsMangelhaftCli;
        TestConfiguration testConfig = this.testConfigurationConverter.toTestConfiguration(configuration);
        if (testConfig == null) {
            throw new CoreException(this.statusHelper.createError("Couldn't obtain test configuration."));
        }
        IN4JSProject containingProject = (IN4JSProject)this.n4jsCore.findProject(testConfig.getUserSelection()).orNull();
        if (containingProject != null && (n4jsMangelhaftCli = (IN4JSProject)containingProject.getAllDirectDependencies().stream().filter(p -> N4JSGlobals.MANGELHAFT_CLI.equals((Object)p.getProjectName())).findFirst().orElse(null)) == null) {
            throw new CoreException(this.statusHelper.createError("Testing in IDE requires package '" + N4JSGlobals.MANGELHAFT_CLI + "' to be defined as dependency or devDependency in package.json of containing project '" + containingProject.getProjectName() + "'."));
        }
        try {
            String launchConfigName = launch.getLaunchConfiguration().getName();
            Process process = this.testerFrontEndUI.runInUI(testConfig);
            DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)launchConfigName);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error occurred while trying to execute module.", (Throwable)e);
            if (e instanceof CoreException) {
                throw (CoreException)((Object)e);
            }
            throw new CoreException(this.statusHelper.createError((Throwable)e));
        }
    }
}

