/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.types.util;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsFactory;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.PrimitiveType;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TObjectPrototype;
import org.eclipse.n4js.ts.types.util.AbstractCompleteHierarchyTraverser;

public class AllSuperTypeRefsCollector
extends AbstractCompleteHierarchyTraverser<List<ParameterizedTypeRef>> {
    private final List<ParameterizedTypeRef> result = Lists.newArrayList();

    public AllSuperTypeRefsCollector(ContainerType<?> type) {
        super(type);
    }

    @Override
    protected List<ParameterizedTypeRef> doGetResult() {
        return this.result;
    }

    @Override
    protected void doProcess(ContainerType<?> containerType) {
        PrimitiveType assignmentCompatible;
        if (containerType instanceof TClass) {
            TClass casted = (TClass)containerType;
            ParameterizedTypeRef superType = casted.getSuperClassRef();
            this.result.addAll((Collection<ParameterizedTypeRef>)casted.getImplementedInterfaceRefs());
            if (superType != null) {
                this.result.add(superType);
            }
        } else if (containerType instanceof TInterface) {
            TInterface casted = (TInterface)containerType;
            this.result.addAll((Collection<ParameterizedTypeRef>)casted.getSuperInterfaceRefs());
        } else if (containerType instanceof TObjectPrototype) {
            TObjectPrototype casted = (TObjectPrototype)containerType;
            ParameterizedTypeRef superType = casted.getSuperType();
            if (superType != null) {
                this.result.add(superType);
            }
        } else if (containerType instanceof PrimitiveType && (assignmentCompatible = ((PrimitiveType)containerType).getAssignmentCompatible()) != null) {
            ParameterizedTypeRef typeRef = TypeRefsFactory.eINSTANCE.createParameterizedTypeRef();
            typeRef.setDeclaredType(assignmentCompatible);
            this.result.add(typeRef);
        }
    }

    public static final List<ParameterizedTypeRef> collect(ContainerType<?> type) {
        return (List)new AllSuperTypeRefsCollector(type).getResult();
    }
}

