/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.utils;

import com.google.inject.Inject;
import com.google.inject.Injector;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.n4js.ui.N4JSEditor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.ui.editor.IURIEditorOpener;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.IssueModificationContext;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.Issue;

public class IssueUtilN4 {
    @Inject
    private IssueModificationContext.Factory modificationContextFactory;
    @Inject
    private Injector tempInjector;

    private IURIEditorOpener getEditorOpener() {
        IURIEditorOpener _xifexpression = null;
        boolean _isWorkbenchRunning = PlatformUI.isWorkbenchRunning();
        _xifexpression = _isWorkbenchRunning ? (IURIEditorOpener)this.tempInjector.getInstance(IURIEditorOpener.class) : null;
        return _xifexpression;
    }

    public IModificationContext getContext(Issue issue) {
        return this.modificationContextFactory.createModificationContext(issue);
    }

    public IXtextDocument getDocument(Issue issue) {
        XtextEditor _editor = null;
        if (issue != null) {
            _editor = this.getEditor(issue, XtextEditor.class);
        }
        IXtextDocument _document = null;
        if (_editor != null) {
            _document = _editor.getDocument();
        }
        return _document;
    }

    public ISourceViewer getViewer(Issue issue) {
        N4JSEditor _editor = null;
        if (issue != null) {
            _editor = this.getEditor(issue, N4JSEditor.class);
        }
        ISourceViewer _sourceViewer2 = null;
        if (_editor != null) {
            _sourceViewer2 = _editor.getSourceViewer2();
        }
        return _sourceViewer2;
    }

    public EObject getElement(IXtextDocument document, Issue issue) {
        EObject _readOnly = null;
        if (document != null) {
            IUnitOfWork _function = resource -> resource.getEObject(issue.getUriToProblem().fragment());
            _readOnly = (EObject)document.readOnly(_function);
        }
        return _readOnly;
    }

    private <T extends IEditorPart> T getEditor(Issue issue, Class<T> expectedType) {
        URI uriToEditor;
        URI _uriToProblem = null;
        if (issue != null) {
            _uriToProblem = issue.getUriToProblem();
        }
        URI _trimFragment = null;
        if (_uriToProblem != null) {
            _trimFragment = _uriToProblem.trimFragment();
        }
        if ((uriToEditor = _trimFragment) != null) {
            IEditorPart editor;
            IURIEditorOpener _editorOpener = this.getEditorOpener();
            IEditorPart _open = null;
            if (_editorOpener != null) {
                _open = _editorOpener.open(uriToEditor, false);
            }
            if ((editor = _open) != null && expectedType.isAssignableFrom(editor.getClass())) {
                return (T)editor;
            }
        }
        return null;
    }
}

