/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.workingsets;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.n4js.ui.ImageDescriptorCache;
import org.eclipse.n4js.ui.workingsets.DefaultWorkingSetImpl;
import org.eclipse.n4js.ui.workingsets.WorkingSet;
import org.eclipse.n4js.ui.workingsets.WorkingSetManager;
import org.eclipse.n4js.ui.workingsets.WorkingSetManagerImpl;
import org.eclipse.n4js.ui.workingsets.WorkspaceRepositoriesProvider;
import org.eclipse.swt.graphics.Image;

public class GitRepositoryAwareWorkingSetManager
extends WorkingSetManagerImpl {
    final WorkspaceRepositoriesProvider repositoriesProvider;

    @Inject
    public GitRepositoryAwareWorkingSetManager(WorkspaceRepositoriesProvider repositoriesProvider) {
        this.repositoriesProvider = repositoriesProvider;
        this.repositoriesProvider.addWorkspaceRepositoriesChangedListener(repos -> this.reload());
    }

    @Override
    public String getLabel() {
        return "Git Repository";
    }

    @Override
    public Optional<Image> getImage() {
        return ImageDescriptorCache.ImageRef.REPOSITORY.asImage();
    }

    @Override
    protected List<WorkingSet> initializeWorkingSets() {
        Set<Repository> repositories = this.repositoriesProvider.getWorkspaceRepositories();
        repositories.add(null);
        return repositories.stream().map(r -> new GitRepositoryWorkingSet((Repository)r, (WorkingSetManager)this)).collect(Collectors.toList());
    }

    public static final class GitRepositoryWorkingSet
    extends DefaultWorkingSetImpl {
        private final String rootUri;
        private final String name;

        private static String repositoryToId(Repository repository) {
            if (repository == null) {
                return "Other Projects";
            }
            return GitRepositoryWorkingSet.toUriString(repository.getDirectory().getParentFile().toURI());
        }

        @VisibleForTesting
        public GitRepositoryWorkingSet(Repository repository, WorkingSetManager manager) {
            super(GitRepositoryWorkingSet.repositoryToId(repository), manager);
            if (repository == null) {
                this.rootUri = null;
                this.name = "Other Projects";
            } else {
                File directory = repository.getDirectory().getParentFile();
                this.rootUri = GitRepositoryWorkingSet.toUriString(directory.toURI());
                this.name = directory.getName();
            }
        }

        public boolean apply(IProject project) {
            return this.rootUri != null && GitRepositoryWorkingSet.toUriString(project.getLocationURI()).startsWith(this.rootUri);
        }

        @Override
        public String getName() {
            return this.name;
        }

        private static String toUriString(URI uri) {
            int length;
            String uriString = uri.toString();
            if (uriString.charAt((length = uriString.length()) - 1) == '/') {
                return uriString.substring(0, length - 1);
            }
            return uriString;
        }
    }
}

