/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.server.resources.sessions;

import com.google.common.base.Throwables;
import com.google.inject.Inject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import org.eclipse.n4js.tester.TesterEventBus;
import org.eclipse.n4js.tester.events.TestEvent;
import org.eclipse.n4js.tester.server.resources.BaseResource;
import org.eclipse.n4js.tester.server.resources.ClientResourceException;

abstract class SessionResource
extends BaseResource {
    private static final Pattern SESSION_ID_PATTERN = Pattern.compile("\\b([^ /]+)\\b");
    @Inject
    private TesterEventBus bus;

    SessionResource() {
    }

    @Override
    protected int doHandle(String body, String pathInfo) throws ServletException {
        Matcher matcher = SESSION_ID_PATTERN.matcher(pathInfo);
        String sessionId = null;
        if (matcher.find()) {
            sessionId = matcher.group();
        }
        if (this.sessionExists(sessionId)) {
            try {
                this.bus.post(this.createEvent(sessionId, body));
            }
            catch (Exception e) {
                Throwable rootCause = Throwables.getRootCause((Throwable)e);
                if (rootCause instanceof ClientResourceException) {
                    throw (ClientResourceException)((Object)rootCause);
                }
                LOGGER.error((Object)("Error while creating event for test session. [Session ID: " + sessionId + "]"), (Throwable)e);
                throw new ServletException((Throwable)e);
            }
            return 200;
        }
        return 404;
    }

    protected abstract TestEvent createEvent(String var1, String var2) throws ServletException;
}

