/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.ui.services;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xpect.XjmXpectMethod;
import org.eclipse.xpect.XpectFile;
import org.eclipse.xpect.XpectInvocation;
import org.eclipse.xpect.XpectJavaModel;
import org.eclipse.xpect.runner.TestExecutor;
import org.eclipse.xpect.runner.Xpect;
import org.eclipse.xpect.state.Configuration;
import org.eclipse.xpect.state.StateContainer;
import org.eclipse.xpect.ui.preferences.XpectRootPreferencePage;
import org.eclipse.xpect.ui.services.LiveTestIssueFactory;
import org.eclipse.xpect.ui.util.XpectFileAccess;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.resource.ProjectByResourceProvider;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.CollectionBasedAcceptor;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.Issue;

public class LiveTestRunner {
    @Inject
    private ProjectByResourceProvider projectByResourceProvider;
    @Inject
    private LiveTestIssueFactory issueFactory;

    protected void configureTests(Resource resource, CheckMode mode, CancelIndicator indicator, Configuration fileConfig) {
        try {
            Class thisResource = Platform.getBundle((String)"org.eclipse.xpect.xtext.lib").loadClass("org.eclipse.xpect.xtext.lib.setup.ThisResource");
            fileConfig.addValue(thisResource, XtextResource.class, (Object)((XtextResource)resource));
        }
        catch (ClassNotFoundException e1) {
            Throwables.propagate((Throwable)e1);
        }
    }

    public List<Issue> validateTests(Resource resource, CheckMode mode, CancelIndicator indicator, Configuration fileConfig) {
        IProject project = this.projectByResourceProvider.getProjectContext(resource);
        if (project == null || !XpectRootPreferencePage.isLiveTestExecutionEnabled(project)) {
            return Collections.emptyList();
        }
        XpectFile xpectFile = XpectFileAccess.getXpectFile(resource);
        if (xpectFile == null || xpectFile.isIgnore()) {
            return Collections.emptyList();
        }
        ArrayList invocations = Lists.newArrayList();
        for (XpectInvocation inv : xpectFile.getInvocations()) {
            Method javaMethod;
            XjmXpectMethod method;
            if (inv.isIgnore() || (method = inv.getMethod()) == null || method.eIsProxy() || (javaMethod = method.getJavaMethod()) == null) continue;
            Xpect annotation = javaMethod.getAnnotation(Xpect.class);
            CheckType checkType = annotation.liveExecution().toCheckType();
            if (annotation == null || checkType == null || !mode.shouldCheck(checkType)) continue;
            invocations.add(inv);
        }
        if (invocations.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        XpectJavaModel javaModel = xpectFile.getJavaModel();
        if (javaModel != null && javaModel.getTestOrSuite() != null && javaModel.getTestOrSuite().getJavaClass() != null) {
            this.configureTests(resource, mode, indicator, fileConfig);
            StateContainer rootState = TestExecutor.createState((Configuration)TestExecutor.createRootConfiguration((XpectJavaModel)javaModel));
            StateContainer fileState = TestExecutor.createState((StateContainer)rootState, (Configuration)fileConfig);
            for (XpectInvocation inv : invocations) {
                StateContainer invState = TestExecutor.createState((StateContainer)fileState, (Configuration)TestExecutor.createXpectConfiguration((XpectInvocation)inv));
                try {
                    try {
                        TestExecutor.runTest((StateContainer)invState, (XpectInvocation)inv);
                        result.add(this.issueFactory.createSuccessIssue(inv));
                    }
                    catch (Throwable e) {
                        this.issueFactory.exceptionToIssues(inv, e, (IAcceptor<Issue>)CollectionBasedAcceptor.of((Collection)result));
                        invState.invalidate();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    invState.invalidate();
                    throw throwable;
                }
                invState.invalidate();
            }
        }
        return result;
    }
}

