/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.external;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.external.ExternalLibraryWorkspace;
import org.eclipse.n4js.external.HlcExternalIndexSynchronizer;
import org.eclipse.n4js.external.LibraryChange;
import org.eclipse.n4js.external.N4JSExternalProject;
import org.eclipse.n4js.external.NpmLogger;
import org.eclipse.n4js.external.ShadowingInfoHelper;
import org.eclipse.n4js.json.JSON.JSONPackage;
import org.eclipse.n4js.preferences.ExternalLibraryPreferenceStore;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.projectModel.locations.SafeURI;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.resource.packagejson.PackageJsonResourceDescriptionExtension;
import org.eclipse.n4js.semver.Semver.VersionNumber;
import org.eclipse.n4js.utils.URIUtils;
import org.eclipse.n4js.validation.helper.FolderContainmentHelper;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.xbase.lib.Pair;

@ImplementedBy(value=HlcExternalIndexSynchronizer.class)
public abstract class ExternalIndexSynchronizer {
    @Inject
    protected IN4JSCore core;
    @Inject
    protected ExternalLibraryWorkspace externalLibraryWorkspace;
    @Inject
    protected ShadowingInfoHelper shadowingInfoHelper;
    @Inject
    protected FolderContainmentHelper containmentHelper;
    @Inject
    protected ExternalLibraryPreferenceStore libraryPreferenceStore;
    @Inject
    protected NpmLogger logger;

    public abstract void synchronizeNpms(IProgressMonitor var1);

    public abstract void synchronizeNpms(IProgressMonitor var1, Collection<LibraryChange> var2);

    public abstract void reindexAllExternalProjects(IProgressMonitor var1);

    public final Map<N4JSProjectName, Pair<FileURI, String>> findNpmsInFolder(ProjectStateOperation operation) {
        HashMap<N4JSProjectName, Pair<FileURI, String>> npmsFolder = new HashMap<N4JSProjectName, Pair<FileURI, String>>();
        List<Object> prjs = Collections.emptyList();
        switch (operation) {
            case NONE: {
                prjs = this.externalLibraryWorkspace.getProjectsIncludingUnnecessary();
                break;
            }
            case PEEK: {
                prjs = this.externalLibraryWorkspace.computeProjectsIncludingUnnecessary();
                break;
            }
            case UPDATE: {
                this.externalLibraryWorkspace.updateState();
                prjs = this.externalLibraryWorkspace.getProjectsIncludingUnnecessary();
            }
        }
        for (org.eclipse.xtext.util.Pair pair : prjs) {
            FileURI location = (FileURI)pair.getFirst();
            IN4JSProject project = (IN4JSProject)this.core.findProject(location.toURI()).orNull();
            if (project == null || this.shadowingInfoHelper.isShadowedProject(project)) continue;
            ProjectDescription projectDescription = (ProjectDescription)pair.getSecond();
            VersionNumber version = projectDescription.getProjectVersion();
            N4JSProjectName name = new N4JSProjectName(projectDescription.getProjectName());
            if (version == null) continue;
            npmsFolder.putIfAbsent(name, (Pair<FileURI, String>)Pair.of((Object)location, (Object)version.toString()));
        }
        return npmsFolder;
    }

    public Map<N4JSProjectName, Pair<FileURI, String>> findNpmsInIndex() {
        HashMap<N4JSProjectName, Pair<FileURI, String>> discoveredNpmsInIndex = new HashMap<N4JSProjectName, Pair<FileURI, String>>();
        ResourceSet resourceSet = this.core.createResourceSet((Optional<IN4JSProject>)Optional.absent());
        IResourceDescriptions index = this.core.getXtextIndex(resourceSet);
        for (IResourceDescription resourceDescription : index.getAllResourceDescriptions()) {
            boolean isExternal = resourceDescription.getURI().isFile();
            if (!isExternal) continue;
            this.addToIndex(discoveredNpmsInIndex, resourceDescription);
        }
        return discoveredNpmsInIndex;
    }

    public boolean isInIndex(N4JSExternalProject project) {
        return this.isInIndex(project.getProjectDescriptionLocation());
    }

    public boolean isInIndex(FileURI projectLocation) {
        if (projectLocation == null) {
            return false;
        }
        ResourceSet resourceSet = this.core.createResourceSet((Optional<IN4JSProject>)Optional.absent());
        IResourceDescriptions index = this.core.getXtextIndex(resourceSet);
        IResourceDescription resourceDescription = index.getResourceDescription(projectLocation.toURI());
        return resourceDescription != null;
    }

    public void checkAndClearIndex(IProgressMonitor monitor) {
        Collection<LibraryChange> changeSet = this.identifyChangeSet(Collections.emptyList(), ProjectStateOperation.UPDATE);
        this.cleanRemovedProjectsFromIndex(monitor, changeSet);
    }

    private void cleanRemovedProjectsFromIndex(IProgressMonitor monitor, Collection<LibraryChange> changeSet) {
        monitor.setTaskName("Deregister removed projects...");
        HashSet<FileURI> cleanProjects = new HashSet<FileURI>();
        for (LibraryChange libChange : changeSet) {
            if (libChange.type != LibraryChange.LibraryChangeType.Removed) continue;
            cleanProjects.add(libChange.location);
        }
        ExternalLibraryWorkspace.RegisterResult cleanResult = this.externalLibraryWorkspace.deregisterProjects(monitor, cleanProjects);
        this.printRegisterResults(cleanResult, "deregistered");
    }

    protected final Collection<LibraryChange> identifyChangeSet(Collection<LibraryChange> forcedChangeSet, ProjectStateOperation operation) {
        int synchronizeStatusCode = this.libraryPreferenceStore.synchronizeNodeModulesFolders().getCode();
        if (synchronizeStatusCode == 1) {
            operation = ProjectStateOperation.NONE;
        }
        LinkedHashSet<LibraryChange> changes = new LinkedHashSet<LibraryChange>(forcedChangeSet);
        Map<N4JSProjectName, Pair<FileURI, String>> npmsOfIndex = this.findNpmsInIndex();
        Map<N4JSProjectName, Pair<FileURI, String>> npmsOfFolder = this.findNpmsInFolder(operation);
        HashSet<N4JSProjectName> differences = new HashSet<N4JSProjectName>();
        differences.addAll(npmsOfIndex.keySet());
        differences.addAll(npmsOfFolder.keySet());
        Sets.SetView intersection = Sets.intersection(npmsOfIndex.keySet(), npmsOfFolder.keySet());
        differences.removeAll((Collection<?>)intersection);
        Iterator iterator = differences.iterator();
        while (iterator.hasNext()) {
            String version;
            FileURI location;
            N4JSProjectName diff;
            N4JSProjectName name = diff = (N4JSProjectName)iterator.next();
            LibraryChange change = null;
            if (npmsOfFolder.containsKey(diff) && this.externalLibraryWorkspace.isNecessary(location = (FileURI)npmsOfFolder.get(name).getKey())) {
                version = (String)npmsOfFolder.get(name).getValue();
                change = new LibraryChange(LibraryChange.LibraryChangeType.Added, location, name, version);
            }
            if (npmsOfIndex.containsKey(diff)) {
                location = (FileURI)npmsOfIndex.get(name).getKey();
                version = (String)npmsOfIndex.get(name).getValue();
                change = new LibraryChange(LibraryChange.LibraryChangeType.Removed, location, name, version);
            }
            if (change == null) continue;
            changes.add(change);
        }
        for (N4JSProjectName name : intersection) {
            boolean versionsChanged;
            String versionIndex = (String)npmsOfIndex.get(name).getValue();
            String versionFolder = (String)npmsOfFolder.get(name).getValue();
            FileURI locationIndex = (FileURI)npmsOfIndex.get(name).getKey();
            FileURI locationFolder = (FileURI)npmsOfFolder.get(name).getKey();
            boolean shadowingChanged = !locationFolder.equals(locationIndex);
            boolean bl = versionsChanged = versionIndex != null && !versionIndex.equals(versionFolder);
            if (!shadowingChanged && !versionsChanged) continue;
            changes.add(new LibraryChange(LibraryChange.LibraryChangeType.Removed, locationIndex, name, versionIndex));
            changes.add(new LibraryChange(LibraryChange.LibraryChangeType.Added, locationFolder, name, versionFolder));
        }
        return changes;
    }

    private void addToIndex(Map<N4JSProjectName, Pair<FileURI, String>> npmsIndex, IResourceDescription resourceDescription) {
        URI uri = URIUtils.addEmptyAuthority((URI)resourceDescription.getURI());
        FileURI nestedLocation = new FileURI(uri);
        FileURI rootLocation = this.externalLibraryWorkspace.getRootLocationForResourceOrInfer(nestedLocation);
        if (rootLocation == null) {
            this.logger.logInfo("Could not find location for: " + nestedLocation.toString() + ".\n Please rebuild external libraries!");
            return;
        }
        N4JSProjectName name = this.getPackageName(nestedLocation, rootLocation);
        FileURI packageLocation = this.createProjectLocation(rootLocation, name);
        String version = this.getVersion(resourceDescription, nestedLocation, name, packageLocation);
        if (!npmsIndex.containsKey(name) || version != null) {
            npmsIndex.put(name, (Pair<FileURI, String>)Pair.of((Object)packageLocation, (Object)version));
        }
    }

    private String getVersion(IResourceDescription resourceDescription, SafeURI<?> nestedLocation, N4JSProjectName name, SafeURI<?> packageLocation) {
        IEObjectDescription pDescription;
        String nameFromPackageJSON;
        if (!this.isProjectDescriptionFile(nestedLocation, packageLocation)) {
            return null;
        }
        Iterable pds = resourceDescription.getExportedObjectsByType(JSONPackage.eINSTANCE.getJSONDocument());
        Iterator pdsIter = pds.iterator();
        if (pdsIter.hasNext() && ((nameFromPackageJSON = PackageJsonResourceDescriptionExtension.getProjectName(pDescription = (IEObjectDescription)pdsIter.next())) == null || name.equals(new N4JSProjectName(nameFromPackageJSON)))) {
            String version = pDescription.getUserData("projectVersion");
            return version;
        }
        return null;
    }

    private boolean isProjectDescriptionFile(SafeURI<?> resourceLocation, SafeURI<?> packageLocation) {
        boolean isProjectDescriptionFile = true;
        isProjectDescriptionFile &= resourceLocation.getName().equals("package.json");
        return isProjectDescriptionFile &= resourceLocation.equals(packageLocation.appendSegment("package.json"));
    }

    private <U extends SafeURI<U>> N4JSProjectName getPackageName(U nestedLocation, U workspaceLocation) {
        if (!this.isParentOf(workspaceLocation, nestedLocation)) {
            throw new IllegalArgumentException("Cannot determine package name of " + nestedLocation + ": The nested location is not contained in the given workspace location " + workspaceLocation);
        }
        List<String> path = nestedLocation.deresolve(workspaceLocation);
        if (path.size() == 0) {
            throw new IllegalArgumentException("Malformed package location " + nestedLocation + ": Expected at least one segment in addition to workspace location " + workspaceLocation + ".");
        }
        if (path.get(0).startsWith("@")) {
            if (path.size() < 2) {
                throw new IllegalArgumentException("Malformed package location: " + nestedLocation);
            }
            return new N4JSProjectName(String.valueOf(path.get(0)) + File.separator + path.get(1));
        }
        return new N4JSProjectName(path.get(0));
    }

    private <U extends SafeURI<U>> boolean isParentOf(U parentLocation, U nestedLocation) {
        return nestedLocation.toFileSystemPath().startsWith(parentLocation.toFileSystemPath());
    }

    private FileURI createProjectLocation(FileURI workspaceLocation, N4JSProjectName projectName) {
        return (FileURI)workspaceLocation.appendPath(projectName.getRawName());
    }

    protected void printRegisterResults(ExternalLibraryWorkspace.RegisterResult rr, String jobName) {
        SortedSet<N4JSProjectName> prjNames;
        if (!rr.externalProjectsDone.isEmpty()) {
            prjNames = this.getProjectNamesFromLocations(rr.externalProjectsDone);
            this.logger.logInfo("External libraries " + jobName + ": " + Joiner.on((String)", ").join(prjNames));
        }
        if (!rr.wipedProjects.isEmpty()) {
            prjNames = new TreeSet<N4JSProjectName>();
            for (SafeURI safeURI : rr.wipedProjects) {
                String projectName = safeURI.getProjectName().getRawName();
                prjNames.add((N4JSProjectName)((Object)projectName));
            }
            this.logger.logInfo("Projects deregistered: " + String.join((CharSequence)", ", prjNames));
        }
        if (!rr.affectedWorkspaceProjects.isEmpty()) {
            prjNames = this.getProjectNamesFromLocations(rr.affectedWorkspaceProjects);
            this.logger.logInfo("Workspace projects affected: " + Joiner.on((String)", ").join(prjNames));
        }
    }

    private SortedSet<N4JSProjectName> getProjectNamesFromLocations(Collection<? extends SafeURI<?>> projectLocations) {
        TreeSet<N4JSProjectName> prjNames = new TreeSet<N4JSProjectName>();
        for (SafeURI<?> location : projectLocations) {
            IN4JSProject p = (IN4JSProject)this.core.findProject(location.toURI()).orNull();
            prjNames.add(p.getProjectName());
        }
        return prjNames;
    }

    public static enum ProjectStateOperation {
        NONE,
        PEEK,
        UPDATE;

    }
}

