/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.n4JS;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.n4js.n4JS.Annotation;
import org.eclipse.n4js.n4JS.ModifiableElement;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.N4Modifier;
import org.eclipse.n4js.ts.types.MemberAccessModifier;
import org.eclipse.n4js.ts.types.TypeAccessModifier;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class ModifierUtils {
    private static final String ANN_INTERNAL = "Internal";

    public static final boolean isValid(EClass astNodeType, N4Modifier modifier) {
        switch (modifier) {
            case PROJECT: 
            case PUBLIC: {
                return ModifierUtils.isN4TypeDeclaration(astNodeType) || ModifierUtils.isN4MemberDeclaration(astNodeType) || ModifierUtils.isFunctionDeclaration(astNodeType) || ModifierUtils.isExportedVariableStatement(astNodeType);
            }
            case PRIVATE: 
            case PROTECTED: {
                return ModifierUtils.isN4MemberDeclaration(astNodeType);
            }
            case EXTERNAL: {
                return ModifierUtils.isN4TypeDeclaration(astNodeType) || ModifierUtils.isFunctionDeclaration(astNodeType) || ModifierUtils.isExportedVariableStatement(astNodeType);
            }
            case ABSTRACT: {
                return ModifierUtils.isN4ClassDeclaration(astNodeType) || ModifierUtils.isN4MethodDeclaration(astNodeType) || ModifierUtils.isN4FieldAccessor(astNodeType);
            }
            case STATIC: {
                return ModifierUtils.isN4MemberDeclaration(astNodeType);
            }
            case CONST: {
                return ModifierUtils.isN4FieldDeclaration(astNodeType);
            }
        }
        return false;
    }

    public static final boolean isAccessModifier(N4Modifier modifier) {
        return modifier == N4Modifier.PRIVATE || modifier == N4Modifier.PROJECT || modifier == N4Modifier.PROTECTED || modifier == N4Modifier.PUBLIC;
    }

    public static final TypeAccessModifier convertToTypeAccessModifier(Collection<? extends N4Modifier> modifiers, List<Annotation> annotations) {
        if (modifiers.contains((Object)N4Modifier.PRIVATE)) {
            return TypeAccessModifier.PRIVATE;
        }
        if (modifiers.contains((Object)N4Modifier.PROJECT)) {
            return TypeAccessModifier.PROJECT;
        }
        if (modifiers.contains((Object)N4Modifier.PUBLIC)) {
            return annotations.stream().anyMatch(a -> ANN_INTERNAL.equals(a.getName())) ? TypeAccessModifier.PUBLIC_INTERNAL : TypeAccessModifier.PUBLIC;
        }
        return TypeAccessModifier.UNDEFINED;
    }

    public static final MemberAccessModifier convertToMemberAccessModifier(Collection<? extends N4Modifier> modifiers, List<Annotation> annotations) {
        if (modifiers.contains((Object)N4Modifier.PRIVATE)) {
            return MemberAccessModifier.PRIVATE;
        }
        if (modifiers.contains((Object)N4Modifier.PROJECT)) {
            return MemberAccessModifier.PROJECT;
        }
        if (modifiers.contains((Object)N4Modifier.PROTECTED)) {
            return annotations.stream().anyMatch(a -> ANN_INTERNAL.equals(a.getName())) ? MemberAccessModifier.PROTECTED_INTERNAL : MemberAccessModifier.PROTECTED;
        }
        if (modifiers.contains((Object)N4Modifier.PUBLIC)) {
            return annotations.stream().anyMatch(a -> ANN_INTERNAL.equals(a.getName())) ? MemberAccessModifier.PUBLIC_INTERNAL : MemberAccessModifier.PUBLIC;
        }
        return MemberAccessModifier.UNDEFINED;
    }

    public static final List<N4Modifier> getSortedModifiers(Collection<? extends N4Modifier> modifiers) {
        ArrayList<N4Modifier> result = new ArrayList<N4Modifier>(modifiers);
        Collections.sort(result, (m1, m2) -> Integer.compare(m1.getValue(), m2.getValue()));
        return result;
    }

    public static final ILeafNode getNodeForModifier(ModifiableElement elem, int index) {
        List nodes = NodeModelUtils.findNodesForFeature((EObject)elem, (EStructuralFeature)N4JSPackage.eINSTANCE.getModifiableElement_DeclaredModifiers());
        if (index >= 0 && index < nodes.size()) {
            Iterable leafNodes = ((INode)nodes.get(index)).getLeafNodes();
            for (ILeafNode currLeaf : leafNodes) {
                if (currLeaf.isHidden()) continue;
                return currLeaf;
            }
        }
        return null;
    }

    private static final boolean isN4TypeDeclaration(EClass astNodeType) {
        return N4JSPackage.eINSTANCE.getN4TypeDeclaration().isSuperTypeOf(astNodeType);
    }

    private static final boolean isN4MemberDeclaration(EClass astNodeType) {
        return N4JSPackage.eINSTANCE.getN4MemberDeclaration().isSuperTypeOf(astNodeType);
    }

    private static final boolean isFunctionDeclaration(EClass astNodeType) {
        return N4JSPackage.eINSTANCE.getFunctionDeclaration().isSuperTypeOf(astNodeType);
    }

    private static final boolean isExportedVariableStatement(EClass astNodeType) {
        return N4JSPackage.eINSTANCE.getExportedVariableStatement().isSuperTypeOf(astNodeType);
    }

    private static final boolean isN4ClassDeclaration(EClass astNodeType) {
        return N4JSPackage.eINSTANCE.getN4ClassDeclaration().isSuperTypeOf(astNodeType);
    }

    private static final boolean isN4FieldDeclaration(EClass astNodeType) {
        return N4JSPackage.eINSTANCE.getN4FieldDeclaration().isSuperTypeOf(astNodeType);
    }

    private static final boolean isN4FieldAccessor(EClass astNodeType) {
        return N4JSPackage.eINSTANCE.getN4FieldAccessor().isSuperTypeOf(astNodeType);
    }

    private static final boolean isN4MethodDeclaration(EClass astNodeType) {
        return N4JSPackage.eINSTANCE.getN4MethodDeclaration().isSuperTypeOf(astNodeType);
    }
}

