/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.ui.methods;

import com.google.common.collect.Lists;
import com.google.inject.Provider;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.Token;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.parser.antlr.lexer.InternalN4JSLexer;
import org.eclipse.n4js.tests.outline.AbstractOutlineWorkbenchTest;
import org.eclipse.xpect.runner.Xpect;
import org.eclipse.xpect.xtext.lib.setup.ThisResource;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.SyntheticCompositeNode;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.util.ReplaceRegion;
import org.junit.Assert;

public class OutlineXpectMethod
extends AbstractOutlineWorkbenchTest {
    private final Provider<? extends Lexer> lexerProvider = new Provider<Lexer>(){

        public Lexer get() {
            return new InternalN4JSLexer(null);
        }
    };

    @Xpect
    public void assertNoExceptionWhenExpandingAllOutlineNodes(@ThisResource XtextResource resource) throws Exception {
        String platformStr = resource.getURI().toString().replace("platform:/resource/", "");
        this.file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformStr));
        super.setUp();
        this.assertNoExceptionSmoke(resource);
    }

    private void assertNoException(String mode) throws Exception {
        try {
            this.traverseChildren(this.modelNode);
        }
        catch (Exception exc) {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            exc.printStackTrace(printWriter);
            Assert.fail((String)("Exception in outline tree construction when in mode \"" + mode + "\": \n" + ((Object)writer).toString()));
        }
    }

    private void assertNoExceptionSmoke(XtextResource resource) throws Exception {
        String text = this.document.get();
        this.assertNoException("default");
        this.skipLastCharacters(text);
        this.skipFirstCharacters(text);
        this.skipCharactersInBetween(text);
        this.skipThreeCharactersInBetween(text);
        this.skipTokensInBetween(text);
        this.skipNodesInBetween((Script)resource.getContents().get(0));
    }

    private void skipLastCharacters(CharSequence input) throws Exception {
        String string = input.toString();
        int i = 0;
        while (i < input.length()) {
            this.processFile(string.substring(0, i), "skipLastCharacters");
            ++i;
        }
    }

    private void skipFirstCharacters(CharSequence input) throws Exception {
        String string = input.toString();
        int i = 0;
        while (i < input.length()) {
            this.processFile(string.substring(i), "skipFirstCharacters");
            ++i;
        }
    }

    private void skipCharactersInBetween(CharSequence input) throws Exception {
        String string = input.toString();
        if (input.length() > 1) {
            int i = 0;
            while (i < input.length() - 1) {
                this.processFile(String.valueOf(string.substring(0, i)) + string.substring(i + 1), "skipCharactersInBetween");
                ++i;
            }
        }
    }

    private void skipThreeCharactersInBetween(CharSequence input) throws Exception {
        String string = input.toString();
        if (input.length() > 4) {
            int i = 0;
            while (i < input.length() - 3) {
                this.processFile(String.valueOf(string.substring(0, i)) + string.substring(i + 3), "skipThreeCharactersInBetween");
                ++i;
            }
        }
    }

    private void skipTokensInBetween(CharSequence input) throws Exception {
        String string = input.toString();
        ArrayList tokenList = Lists.newArrayList();
        Lexer lexer = (Lexer)this.lexerProvider.get();
        lexer.setCharStream((CharStream)new ANTLRStringStream(string));
        Token token = lexer.nextToken();
        while (token != Token.EOF_TOKEN) {
            tokenList.add((CommonToken)token);
            token = lexer.nextToken();
        }
        for (CommonToken token2 : tokenList) {
            int start = token2.getStartIndex();
            int length = token2.getText().length();
            this.processFile(String.valueOf(string.substring(0, start)) + string.substring(start + length), "skipTokensInBetween");
        }
    }

    private void skipNodesInBetween(Script script) throws Exception {
        if (script != null) {
            XtextResource resource = (XtextResource)script.eResource();
            ICompositeNode rootNode = resource.getParseResult().getRootNode();
            ReplaceRegion region = null;
            for (INode node : rootNode.getAsTreeIterable()) {
                if (!(node instanceof ICompositeNode) || node instanceof SyntheticCompositeNode) continue;
                ICompositeNode casted = (ICompositeNode)node;
                int offset = node.getTotalOffset();
                int length = node.getTotalLength();
                if (length == 0 || !casted.getFirstChild().equals(casted.getLastChild()) || region != null && region.getOffset() == offset && region.getLength() == length) continue;
                region = new ReplaceRegion(offset, length, "");
                StringBuilder builder = new StringBuilder(rootNode.getText());
                region.applyTo(builder);
                this.processFile(builder.toString(), "skipNodesInBetween");
            }
        }
    }

    private void processFile(String text, String mode) throws Exception {
        this.document.set(text);
        this.assertNoException(mode);
    }

    private void traverseChildren(IOutlineNode node) {
        for (IOutlineNode child : node.getChildren()) {
            this.traverseChildren(child);
        }
    }

    protected boolean shouldCreateProjectStructure() {
        return false;
    }

    protected boolean checkForCleanWorkspace() {
        return false;
    }

    protected String getFileName() {
        return null;
    }

    protected String getModuleFolder() {
        return null;
    }

    protected String getProjectName() {
        return null;
    }

    protected String getModelAsText() {
        return null;
    }
}

