/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.json.extension;

import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.n4js.json.extension.IJSONResourceDescriptionExtension;
import org.eclipse.n4js.json.validation.extension.IJSONValidatorExtension;

@Singleton
public class JSONExtensionRegistry {
    private static final String JSON_VALIDATORS_EXTENSIONS_POINT_ID = "org.eclipse.n4js.json.validation";
    private static final String JSON_RESOURCE_DESCRIPTION_EXTENSIONS_POINT_ID = "org.eclipse.n4js.json.resourceDescription";
    private static final String JSON_EXTENSIONS_POINT_CLASS_PROPERTY = "class";
    private static final Logger LOGGER = Logger.getLogger(JSONExtensionRegistry.class);
    private boolean isInitialized = false;
    private Set<IJSONValidatorExtension> validatorExtensions;
    private Set<IJSONResourceDescriptionExtension> resourceDescriptionExtensions;

    private void initialize() {
        if (this.isInitialized) {
            LOGGER.warn((Object)"JSONValidatorExtensionRegistry has already been initialized.");
            return;
        }
        this.validatorExtensions = new HashSet<IJSONValidatorExtension>();
        this.resourceDescriptionExtensions = new HashSet<IJSONResourceDescriptionExtension>();
        this.isInitialized = true;
        this.createExecutableExtensions(JSON_VALIDATORS_EXTENSIONS_POINT_ID, IJSONValidatorExtension.class).forEach(this::register);
        this.createExecutableExtensions(JSON_RESOURCE_DESCRIPTION_EXTENSIONS_POINT_ID, IJSONResourceDescriptionExtension.class).forEach(this::register);
    }

    private <T> List<T> createExecutableExtensions(String extensionPointId, Class<T> extensionClass) {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        if (registry == null) {
            return Collections.emptyList();
        }
        IExtension[] extensions = registry.getExtensionPoint(extensionPointId).getExtensions();
        ArrayList<T> executableExtensions = new ArrayList<T>();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElems;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElems = extension.getConfigurationElements();
            int n3 = configElems.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement elem = iConfigurationElementArray[n4];
                try {
                    Object executableExtension = elem.createExecutableExtension(JSON_EXTENSIONS_POINT_CLASS_PROPERTY);
                    executableExtensions.add(extensionClass.cast(executableExtension));
                }
                catch (Exception ex) {
                    LOGGER.error((Object)"Error while reading extensions for extension point org.eclipse.n4js.json.validation", (Throwable)ex);
                }
                ++n4;
            }
            ++n2;
        }
        return executableExtensions;
    }

    public Collection<IJSONValidatorExtension> getValidatorExtensions() {
        this.ensureInitialization();
        return this.validatorExtensions;
    }

    public Collection<IJSONResourceDescriptionExtension> getResourceDescriptionExtensions() {
        this.ensureInitialization();
        return this.resourceDescriptionExtensions;
    }

    public void register(IJSONValidatorExtension validatorExtension) {
        this.ensureInitialization();
        this.validatorExtensions.add(validatorExtension);
    }

    public void register(IJSONResourceDescriptionExtension resourceDescriptionExtension) {
        this.ensureInitialization();
        this.resourceDescriptionExtensions.add(resourceDescriptionExtension);
    }

    private void ensureInitialization() {
        if (!this.isInitialized) {
            this.initialize();
        }
    }
}

