/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.labeling;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.ui.labeling.N4JSHoverProvider;
import org.eclipse.n4js.utils.UtilN4;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

public class N4JSTypeInformationHoverProvider
extends N4JSHoverProvider {
    @Inject
    @Extension
    private N4JSTypeSystem _n4JSTypeSystem;

    @Override
    protected boolean hasHover(EObject obj) {
        return this.doHasHover(obj);
    }

    @Override
    protected String getLabel(EObject obj) {
        return UtilN4.sanitizeForHTML((String)Strings.nullToEmpty((String)this.doGetLabel(obj)));
    }

    @Override
    protected String getFirstLine(EObject obj) {
        String label = this.getLabel(obj);
        String _xifexpression = null;
        boolean _isNullOrEmpty = Strings.isNullOrEmpty((String)label);
        if (_isNullOrEmpty) {
            _xifexpression = null;
        } else {
            boolean _not;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Type of selected expression:<br>");
            boolean _contains = label.contains("<b>");
            boolean bl = _not = !_contains;
            if (_not) {
                _builder.append("<b>");
                _builder.append(label);
                _builder.append("</b>");
            } else {
                _builder.append(label);
            }
            _xifexpression = _builder.toString();
        }
        return _xifexpression;
    }

    protected String getHoverInfoAsHtml(EObject obj) {
        boolean _not;
        boolean _hasHover = this.hasHover(obj);
        boolean bl = _not = !_hasHover;
        if (_not) {
            return null;
        }
        String firstLine = this.getFirstLine(obj);
        boolean _isNullOrEmpty = Strings.isNullOrEmpty((String)firstLine);
        if (_isNullOrEmpty) {
            return null;
        }
        StringBuilder sb = new StringBuilder(firstLine);
        String documentation = this.getDocumentation(obj);
        if (documentation != null && documentation.length() > 0) {
            sb.append("<p>");
            sb.append(documentation);
            sb.append("</p>");
        }
        return sb.toString();
    }

    private boolean _doHasHover(EObject obj) {
        return super.hasHover(obj);
    }

    private boolean _doHasHover(Expression expression) {
        return true;
    }

    private String _doGetLabel(EObject obj) {
        return super.getLabel(obj);
    }

    private String _doGetLabel(Expression expression) {
        boolean _tripleEquals;
        Resource _eResource = expression.eResource();
        boolean bl = _tripleEquals = _eResource == null;
        if (_tripleEquals) {
            return null;
        }
        TypeRef type = this._n4JSTypeSystem.type(RuleEnvironmentExtensions.newRuleEnvironment((EObject)expression), (TypableElement)expression);
        String _xifexpression = null;
        _xifexpression = type == null ? null : type.getTypeRefAsString();
        return _xifexpression;
    }

    private boolean doHasHover(EObject expression) {
        if (expression instanceof Expression) {
            return this._doHasHover((Expression)expression);
        }
        if (expression != null) {
            return this._doHasHover(expression);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(expression).toString());
    }

    private String doGetLabel(EObject expression) {
        if (expression instanceof Expression) {
            return this._doGetLabel((Expression)expression);
        }
        if (expression != null) {
            return this._doGetLabel(expression);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(expression).toString());
    }
}

