/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.server.resources;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.eclipse.n4js.tester.server.resources.BaseResource;
import org.eclipse.n4js.tester.server.resources.ClientResourceException;
import org.eclipse.n4js.tester.server.resources.HttpMethod;
import org.eclipse.n4js.tester.server.resources.Resource;
import org.eclipse.n4js.tester.server.resources.ResourceDescriptor;
import org.eclipse.n4js.tester.server.resources.ResourceProvider;
import org.eclipse.n4js.tester.server.resources.service.TestCatalogAssemblerResource;
import org.eclipse.n4js.tester.server.resources.sessions.EndSessionResource;
import org.eclipse.n4js.tester.server.resources.sessions.PingSessionResource;
import org.eclipse.n4js.tester.server.resources.sessions.StartSessionResource;
import org.eclipse.n4js.tester.server.resources.tests.EndTestResource;
import org.eclipse.n4js.tester.server.resources.tests.PingTestResource;
import org.eclipse.n4js.tester.server.resources.tests.StartTestResource;

public class ResourceRouterServlet
extends HttpServlet {
    private static final Logger LOGGER = Logger.getLogger(ResourceRouterServlet.class);
    public static final String CONTEXT_PATH = "/testing/sessions/";
    private static Collection<Class<?>> RESOURCE_CLASSES = Collections.unmodifiableCollection(Arrays.asList(StartSessionResource.class, PingSessionResource.class, EndSessionResource.class, StartTestResource.class, PingTestResource.class, EndTestResource.class, TestCatalogAssemblerResource.class));
    private static final Supplier<Iterable<ResourceDescriptor>> RESOURCE_DESCRIPTORS = Suppliers.memoize((Supplier)new Supplier<Iterable<ResourceDescriptor>>(){

        public Iterable<ResourceDescriptor> get() {
            return Iterables.transform((Iterable)Iterables.filter(RESOURCE_CLASSES, clazz -> BaseResource.class.isAssignableFrom((Class<?>)clazz) && clazz.isAnnotationPresent(Resource.class)), clazz -> new ResourceDescriptor(clazz.getAnnotation(Resource.class), (Class<? extends BaseResource>)clazz));
        }
    });
    @Inject
    private ResourceProvider resourceProvider;

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = this.getEscapedPathInfo(req);
        Optional opt = Iterables.tryFind((Iterable)((Iterable)RESOURCE_DESCRIPTORS.get()), desc -> desc.matchesWithPathInfo(pathInfo));
        if (!opt.isPresent()) {
            resp.setStatus(404);
            return;
        }
        ResourceDescriptor desc2 = (ResourceDescriptor)opt.get();
        if (!Iterables.any(desc2.getMethods(), method -> HttpMethod.equalsWithMethod(method, req))) {
            resp.setStatus(405);
            return;
        }
        Collection<String> contentType = desc2.getRequestContentType();
        if (!Iterables.any((Iterable)Splitter.on((String)";").trimResults().split((CharSequence)Strings.nullToEmpty((String)req.getContentType())), (Predicate)Predicates.in(contentType))) {
            resp.setStatus(415);
            return;
        }
        try {
            BaseResource resource = this.resourceProvider.createResource(desc2.getClazz());
            resource.doHandle(req, resp, pathInfo);
            resp.setContentType(desc2.getResponseContentType());
            if (200 == resp.getStatus()) {
                resource.handleStatusOk(req, resp, pathInfo);
            }
        }
        catch (ClientResourceException e) {
            resp.reset();
            resp.setStatus(e.getStatusCode());
        }
        catch (Exception e) {
            LOGGER.error((Object)("Unexpected error while trying to serve request.\nPath info: '" + req.getPathInfo() + "'."), (Throwable)e);
        }
    }

    private String getEscapedPathInfo(HttpServletRequest req) throws ServletException {
        URI escapedPathInfoURI;
        try {
            escapedPathInfoURI = new URI(String.valueOf(req.getContextPath()) + CONTEXT_PATH).relativize(new URI(req.getRequestURI()));
        }
        catch (URISyntaxException e) {
            throw new ServletException("Failed to extract un-escaped path info from request.", (Throwable)e);
        }
        return "/" + escapedPathInfoURI.toString();
    }
}

