/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.util;

import com.google.inject.Inject;
import org.eclipse.jface.dialogs.IDialogSettings;

public class DontAskAgainPreferences {
    public static final String DONT_ASK_AGAIN_PREFERENCE_PREFIX = "dont_ask_again_preference";
    @Inject
    private IDialogSettings dialogSettings;

    protected String getPrefix() {
        return DONT_ASK_AGAIN_PREFERENCE_PREFIX;
    }

    public boolean shouldAskAgain(String key) {
        return !"never".equals(this.getUserDecision(key));
    }

    protected void neverAskAgain(String key) {
        this.storeUserDecision(key, "never");
    }

    public String getUserDecision(String key) {
        String userDecision = this.getDontAskAgainDialogSettings().get(key);
        if (userDecision == null) {
            userDecision = "prompt";
        }
        return userDecision;
    }

    public void forgetAllUserDecisions() {
        this.dialogSettings.addNewSection(this.getPrefix());
    }

    protected IDialogSettings getDontAskAgainDialogSettings() {
        IDialogSettings section = this.dialogSettings.getSection(this.getPrefix());
        if (section == null) {
            return this.dialogSettings.addNewSection(this.getPrefix());
        }
        return section;
    }

    protected void storeUserDecision(String key, String value) {
        this.getDontAskAgainDialogSettings().put(key, value);
    }
}

