/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.binaries.nodejs;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.inject.Singleton;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Provider;
import org.eclipse.n4js.binaries.Binary;
import org.eclipse.n4js.binaries.nodejs.NpmBinary;
import org.eclipse.n4js.binaries.nodejs.NpmrcBinary;
import org.eclipse.n4js.binaries.nodejs.YarnBinary;
import org.eclipse.n4js.utils.NodeModulesDiscoveryHelper;
import org.eclipse.n4js.utils.OSInfo;
import org.eclipse.xtext.xbase.lib.Pair;

@Singleton
public class NodeYarnProcessBuilder {
    public static final String[] WIN_SHELL_COMAMNDS = new String[]{"cmd", "/c"};
    public static final String[] NIX_SHELL_COMAMNDS = new String[]{"sh", "-c"};
    public static final Map<String, String> additionalEnvironmentVariables = new ConcurrentHashMap<String, String>();
    @Inject
    private Provider<NpmBinary> npmBinaryProvider;
    @Inject
    private Provider<YarnBinary> yarnBinaryProvider;
    @Inject
    private Provider<NpmrcBinary> npmrcBinaryProvider;
    @Inject
    private NodeModulesDiscoveryHelper nodeModulesDiscoveryHelper;

    public ProcessBuilder getNpmCacheCleanProcessBuilder(File invocationPath) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Binary binary = this.isYarnUsed(invocationPath.toPath()) ? (Binary)this.yarnBinaryProvider.get() : (Binary)this.npmBinaryProvider.get();
        Optional<String[]> cacheCleanCommand = binary.getCacheCleanCommand();
        if (!cacheCleanCommand.isPresent()) {
            throw new IllegalStateException("cache clean not supported by binary: " + binary.getId());
        }
        if (OSInfo.isWindows()) {
            builder.add((Object[])WIN_SHELL_COMAMNDS);
            builder.add((Object[])NodeYarnProcessBuilder.concat(this.escapeBinaryPath(binary.getBinaryAbsolutePath()), (String[])cacheCleanCommand.get()));
        } else {
            builder.add((Object[])NIX_SHELL_COMAMNDS);
            builder.add((Object)(String.valueOf(this.escapeBinaryPath(binary.getBinaryAbsolutePath())) + " " + Joiner.on((String)" ").join((Object[])cacheCleanCommand.get())));
        }
        return this.create((List<String>)builder.build(), binary, invocationPath, false);
    }

    public ProcessBuilder getInstallNpmPackageProcessBuilder(File invocationPath, String packageName, boolean save) {
        ProcessBuilder pb = this.installUninstallCall(invocationPath, Operation.INSTALL, packageName, save);
        Binary npmrc = (Binary)this.npmrcBinaryProvider.get();
        npmrc.updateEnvironment(pb.environment());
        return pb;
    }

    public ProcessBuilder getUninstallNpmPackageProcessBuilder(File invocationPath, String packageName, boolean save) {
        return this.installUninstallCall(invocationPath, Operation.UNINSTALL, packageName, save);
    }

    private ProcessBuilder installUninstallCall(File invocationPath, Operation operation, String packageName, boolean save) {
        Binary binary;
        Objects.requireNonNull(packageName);
        Binary binary2 = binary = this.isYarnUsed(invocationPath.toPath()) ? (Binary)this.yarnBinaryProvider.get() : (Binary)this.npmBinaryProvider.get();
        if (!binary.canInstallNpmPackages()) {
            throw new IllegalStateException("(un-)installing npm packages not supported by binary: " + binary.getId());
        }
        String simpleCommand = null;
        switch (operation) {
            case INSTALL: {
                simpleCommand = binary.getNpmInstallCommand(packageName.trim().isEmpty());
                break;
            }
            case UNINSTALL: {
                simpleCommand = binary.getNpmUninstallCommand();
            }
        }
        Optional<Pair<String, String>> saveOptions = binary.getNpmSaveOptions();
        String saveOption = saveOptions.isPresent() ? (save ? (String)((Pair)saveOptions.get()).getKey() : (String)((Pair)saveOptions.get()).getValue()) : "";
        ImmutableList.Builder builder = ImmutableList.builder();
        if (OSInfo.isWindows()) {
            builder.add((Object[])WIN_SHELL_COMAMNDS);
            builder.add((Object[])new String[]{this.escapeBinaryPath(binary.getBinaryAbsolutePath()), simpleCommand, packageName, saveOption});
        } else {
            builder.add((Object[])NIX_SHELL_COMAMNDS);
            builder.add((Object)(String.valueOf(this.escapeBinaryPath(binary.getBinaryAbsolutePath())) + " " + simpleCommand + " " + packageName + " " + saveOption));
        }
        return this.create((List<String>)builder.build(), binary, invocationPath, false);
    }

    public boolean isYarnUsed(Path projectFolder) {
        return this.isYarnRequired(projectFolder);
    }

    private boolean isYarnRequired(Path projectFolder) {
        NodeModulesDiscoveryHelper.NodeModulesFolder nodeModulesFolder = this.nodeModulesDiscoveryHelper.getNodeModulesFolder(projectFolder);
        return nodeModulesFolder != null && nodeModulesFolder.isYarnWorkspace;
    }

    public ProcessBuilder createVersionCheckProcess(Binary binary) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (OSInfo.isWindows()) {
            builder.add((Object[])WIN_SHELL_COMAMNDS);
        } else {
            builder.add((Object[])NIX_SHELL_COMAMNDS);
        }
        builder.add((Object)(String.valueOf(this.escapeBinaryPath(binary.getBinaryAbsolutePath())) + " " + binary.getVersionArgument()));
        return this.create((List<String>)builder.build(), binary, null, false);
    }

    private ProcessBuilder create(List<String> commands, Binary binary, File workingDirectory, boolean redirectErrorStream) {
        ProcessBuilder processBuilder = new ProcessBuilder(commands);
        processBuilder.redirectErrorStream(redirectErrorStream);
        processBuilder.environment().putAll(additionalEnvironmentVariables);
        binary.updateEnvironment(processBuilder.environment());
        if (workingDirectory != null) {
            processBuilder.directory(workingDirectory);
        }
        return processBuilder;
    }

    private String escapeBinaryPath(String path) {
        return "\"" + path + "\"";
    }

    private static String[] concat(String string, String ... moreStrings) {
        String[] result = new String[moreStrings.length + 1];
        result[0] = string;
        System.arraycopy(moreStrings, 0, result, 1, moreStrings.length);
        return result;
    }

    private static enum Operation {
        INSTALL,
        UNINSTALL;

    }
}

