/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.analysers;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.flowgraphs.analysis.BranchWalker;
import org.eclipse.n4js.flowgraphs.analysis.GraphExplorer;
import org.eclipse.n4js.flowgraphs.analysis.GraphExplorerInternal;
import org.eclipse.n4js.flowgraphs.analysis.GraphVisitor;
import org.eclipse.n4js.flowgraphs.analysis.TraverseDirection;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.UnaryExpression;
import org.eclipse.n4js.n4JS.UnaryOperator;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;

public class TypeGuardVisitor
extends GraphVisitor {
    final N4JSTypeSystem ts;
    final TypeRef reqTypeRef;
    final ControlFlowElement cfElem;

    TypeGuardVisitor(N4JSTypeSystem ts, TypeRef reqTypeRef, ControlFlowElement cfElem) {
        super(TraverseDirection.Backward);
        this.ts = ts;
        this.reqTypeRef = reqTypeRef;
        this.cfElem = cfElem;
    }

    protected void visit(ControlFlowElement cfe) {
        if (this.cfElem == cfe) {
            super.requestActivation((GraphExplorerInternal)new TypeGuardExplorer());
        }
    }

    class TypeGuardExplorer
    extends GraphExplorer {
        TypeGuardExplorer() {
            super(GraphExplorerInternal.Quantor.ForAllBranches);
        }

        protected TypeGuardWalker firstBranchWalker() {
            return new TypeGuardWalker();
        }

        protected BranchWalker joinBranches(List<BranchWalker> branchWalkers) {
            return new TypeGuardWalker();
        }
    }

    class TypeGuardWalker
    extends BranchWalker {
        TypeGuardWalker() {
        }

        protected void visit(ControlFlowElement cfe) {
            TypeRef tRef;
            Expression typeExpression;
            RuleEnvironment G;
            UnaryExpression ue;
            if (cfe instanceof UnaryExpression && (ue = (UnaryExpression)cfe).getOp() == UnaryOperator.TYPEOF && TypeGuardVisitor.this.ts.subtypeSucceeded(G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)(typeExpression = ue.getExpression())), (TypeArgument)TypeGuardVisitor.this.reqTypeRef, (TypeArgument)(tRef = TypeGuardVisitor.this.ts.type(G, (TypableElement)ue)))) {
                super.deactivate();
            }
        }

        protected TypeGuardWalker forkPath() {
            return new TypeGuardWalker();
        }

        protected void terminate() {
            this.fail();
        }
    }
}

