/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.types.util;

import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.MemberAccessModifier;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeAccessModifier;

public class AccessModifiers {
    public static MemberAccessModifier toMemberModifier(Type type) {
        return AccessModifiers.toMemberModifier(type == null ? TypeAccessModifier.UNDEFINED : type.getTypeAccessModifier());
    }

    public static MemberAccessModifier toMemberModifier(TypeAccessModifier modifier) {
        switch (modifier) {
            case PRIVATE: {
                return MemberAccessModifier.PRIVATE;
            }
            case PROJECT: {
                return MemberAccessModifier.PROJECT;
            }
            case PUBLIC_INTERNAL: {
                return MemberAccessModifier.PUBLIC_INTERNAL;
            }
            case PUBLIC: {
                return MemberAccessModifier.PUBLIC;
            }
        }
        return MemberAccessModifier.PROJECT;
    }

    public static boolean less(MemberAccessModifier memberAccessModifier, TypeAccessModifier typeAccessModifier) {
        return AccessModifiers.less(memberAccessModifier, AccessModifiers.toMemberModifier(typeAccessModifier));
    }

    public static boolean less(TMember left, TMember right) {
        return AccessModifiers.less(left.getMemberAccessModifier(), right.getMemberAccessModifier());
    }

    public static boolean less(MemberAccessModifier left, MemberAccessModifier right) {
        int iLeft = left.getValue();
        if (iLeft == 0) {
            throw new IllegalArgumentException("Cannot compare with undefined on left");
        }
        int iRight = right.getValue();
        if (iRight == 0) {
            throw new IllegalArgumentException("Cannot compare with undefined on right");
        }
        if (iLeft < iRight) {
            if (left == MemberAccessModifier.PROTECTED) {
                return right != MemberAccessModifier.PUBLIC_INTERNAL;
            }
            if (right == MemberAccessModifier.PROTECTED) {
                return left != MemberAccessModifier.PUBLIC_INTERNAL;
            }
            return true;
        }
        return false;
    }

    public static boolean checkedLess(TMember left, TMember right) {
        MemberAccessModifier fixedLeft = AccessModifiers.fixed(left);
        MemberAccessModifier fixedRight = AccessModifiers.fixed(right);
        return AccessModifiers.less(fixedLeft, fixedRight);
    }

    public static MemberAccessModifier fixed(TMember m) {
        MemberAccessModifier correspondingTypesMAM;
        MemberAccessModifier modifier = m.getMemberAccessModifier();
        ContainerType<?> containingType = m.getContainingType();
        if (containingType instanceof TInterface && (correspondingTypesMAM = AccessModifiers.toMemberModifier(containingType)) == MemberAccessModifier.PRIVATE && containingType instanceof TInterface) {
            MemberAccessModifier memberAccessModifier = MemberAccessModifier.PROJECT;
        }
        return modifier;
    }
}

