/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.runner.ui;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.n4js.runner.ui.IDERunnerDelegate;

public class RunnerUiUtils {
    public static String getRunnerId(ILaunchConfiguration launchConfig, boolean failFast) {
        try {
            String id = launchConfig.getAttribute("RUNNER_ID", null);
            if (id != null) {
                return id;
            }
            ILaunchConfigurationType launchConfigType = launchConfig.getType();
            return RunnerUiUtils.getRunnerId(launchConfigType, failFast);
        }
        catch (CoreException e) {
            if (failFast) {
                throw new WrappedException((Exception)((Object)e));
            }
            return null;
        }
    }

    public static String getRunnerId(ILaunchConfigurationType launchConfigType, boolean failFast) {
        Set modeCombis = launchConfigType.getSupportedModeCombinations();
        HashSet<String> runnerIds = new HashSet<String>();
        for (Set modeCombi : modeCombis) {
            ILaunchDelegate[] delegates;
            try {
                delegates = launchConfigType.getDelegates(modeCombi);
            }
            catch (CoreException e) {
                continue;
            }
            ILaunchDelegate[] iLaunchDelegateArray = delegates;
            int n = delegates.length;
            int n2 = 0;
            while (n2 < n) {
                String runnerId;
                ILaunchConfigurationDelegate launchConfigDelegate;
                ILaunchDelegate launchDelegate = iLaunchDelegateArray[n2];
                try {
                    launchConfigDelegate = launchDelegate.getDelegate();
                }
                catch (CoreException e) {
                    throw new WrappedException("error while getting launch configuration delegate from launch delegate", (Exception)((Object)e));
                }
                if (launchConfigDelegate instanceof IDERunnerDelegate && (runnerId = ((IDERunnerDelegate)launchConfigDelegate).getRunnerId()) != null) {
                    runnerIds.add(runnerId);
                }
                ++n2;
            }
        }
        if (runnerIds.size() == 1) {
            return (String)runnerIds.iterator().next();
        }
        if (failFast) {
            if (runnerIds.isEmpty()) {
                throw new IllegalStateException("cannot find an N4JS runner ID for the launch configuration type with ID: " + launchConfigType.getIdentifier());
            }
            throw new IllegalStateException("several N4JS runner IDs used for a single ILaunchConfigurationType: " + launchConfigType.getIdentifier());
        }
        return null;
    }
}

