/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.members;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.n4JS.N4JSASTUtils;
import org.eclipse.n4js.n4JS.extensions.ExpressionExtensions;
import org.eclipse.n4js.scoping.utils.UnsatisfiedRWAccessDescription;
import org.eclipse.n4js.scoping.utils.WrongStaticAccessDescription;
import org.eclipse.n4js.scoping.utils.WrongWriteAccessDescription;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.AbstractScope;

public abstract class AbstractMemberScope
extends AbstractScope {
    protected final EObject context;
    protected final Resource contextResource;
    protected final boolean staticAccess;
    protected final boolean structFieldInitMode;
    protected final boolean isDynamicType;
    protected final JavaScriptVariantHelper jsVariantHelper;

    public AbstractMemberScope(IScope parent, EObject context, boolean staticAccess, boolean structFieldInitMode, boolean isDynamicType, JavaScriptVariantHelper jsVariantHelper) {
        super(parent, false);
        if (context == null || context.eResource() == null) {
            throw new NullPointerException("Cannot create member scope for context " + context + " (null or its resource is null).");
        }
        this.context = context;
        this.contextResource = context.eResource();
        this.staticAccess = staticAccess;
        this.structFieldInitMode = structFieldInitMode;
        this.isDynamicType = isDynamicType;
        this.jsVariantHelper = jsVariantHelper;
    }

    protected abstract Collection<? extends TMember> getMembers();

    protected abstract TMember findMember(String var1, boolean var2, boolean var3);

    protected Iterable<IEObjectDescription> getAllLocalElements() {
        Iterable iMembers = Iterables.filter(this.getMembers(), (Predicate)new Predicate<TMember>(){

            public boolean apply(TMember input) {
                return input.isStatic() == AbstractMemberScope.this.staticAccess;
            }
        });
        return Scopes.scopedElementsFor((Iterable)iMembers);
    }

    protected Iterable<IEObjectDescription> getLocalElementsByName(QualifiedName name) {
        IEObjectDescription single = this.getSingleLocalElementByName(name);
        if (single == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(single);
    }

    protected IEObjectDescription getSingleLocalElementByName(QualifiedName name) {
        if (name.getSegmentCount() != 1) {
            return null;
        }
        String nameAsString = name.getFirstSegment();
        if (ExpressionExtensions.isBothReadFromAndWrittenTo(this.context)) {
            TMember reader = this.findMember(nameAsString, false, this.staticAccess);
            TMember writer = this.findMember(nameAsString, true, this.staticAccess);
            if (reader == null && writer == null) {
                return null;
            }
            if (reader == null) {
                return new UnsatisfiedRWAccessDescription(EObjectDescription.create((String)writer.getName(), (EObject)writer), true);
            }
            if (writer == null) {
                return new UnsatisfiedRWAccessDescription(EObjectDescription.create((String)reader.getName(), (EObject)reader), false);
            }
            return this.createSingleElementDescription(writer);
        }
        boolean accessForWriteOperation = ExpressionExtensions.isLeftHandSide(this.context);
        TMember existingMember = this.findMember(nameAsString, accessForWriteOperation, this.staticAccess);
        if (existingMember != null) {
            return this.createSingleElementDescription(existingMember);
        }
        existingMember = this.findMember(nameAsString, !accessForWriteOperation, this.staticAccess);
        if (existingMember != null) {
            boolean isLegalAssOfFinalInCtor;
            boolean isAssOfFinalInCtor = N4JSASTUtils.isSemiLegalAssignmentToFinalFieldInCtor((EObject)this.context.eContainer(), (TMember)existingMember);
            boolean bl = isLegalAssOfFinalInCtor = isAssOfFinalInCtor && !((TField)existingMember).isHasExpression();
            if (isLegalAssOfFinalInCtor) {
                return this.createSingleElementDescription(existingMember);
            }
            if (this.structFieldInitMode && !accessForWriteOperation && existingMember instanceof TSetter) {
                return this.createSingleElementDescription(existingMember);
            }
            if (this.jsVariantHelper.allowWrongReadWrite(this.context)) {
                return this.createSingleElementDescription(existingMember);
            }
            return new WrongWriteAccessDescription(EObjectDescription.create((String)existingMember.getName(), (EObject)existingMember), accessForWriteOperation, isAssOfFinalInCtor);
        }
        existingMember = this.findMember(nameAsString, accessForWriteOperation, !this.staticAccess);
        if (existingMember == null) {
            existingMember = this.findMember(nameAsString, !accessForWriteOperation, !this.staticAccess);
        }
        if (existingMember != null && !this.isDynamicType) {
            return new WrongStaticAccessDescription(EObjectDescription.create((String)existingMember.getName(), (EObject)existingMember), this.staticAccess);
        }
        return null;
    }

    protected IEObjectDescription createSingleElementDescription(TMember existingMember) {
        return EObjectDescription.create((String)existingMember.getName(), (EObject)existingMember);
    }

    protected Iterable<IEObjectDescription> getLocalElementsByEObject(EObject object, URI uri) {
        TMember tMember;
        String name;
        TMember existing;
        if (object instanceof TMember && (existing = this.findMember(name = (tMember = (TMember)object).getName(), tMember.isWriteable(), this.staticAccess)) == object) {
            return Collections.singletonList(EObjectDescription.create((String)existing.getName(), (EObject)existing));
        }
        return Collections.emptyList();
    }
}

