/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.n4js.smith.DataCollector;
import org.eclipse.n4js.smith.TimedDataCollector;

public enum DataCollectors {
    INSTANCE;

    private final Map<String, DataCollector> collectors = new HashMap<String, DataCollector>();
    private final AtomicBoolean pauseAllCollectors = new AtomicBoolean(true);

    public DataCollector getOrCreateDataCollector(String key) {
        if (Strings.isNullOrEmpty((String)key)) {
            throw new RuntimeException("DataCollector key cannot be null or empty");
        }
        return this.get(key, null);
    }

    public DataCollector getOrCreateDataCollector(String key, DataCollector parent) {
        if (Strings.isNullOrEmpty((String)key)) {
            throw new RuntimeException("DataCollector key cannot be null or empty");
        }
        return this.get(key, parent);
    }

    private synchronized DataCollector get(String key, DataCollector parent) {
        DataCollector collector = null;
        if (parent == null) {
            collector = this.collectors.get(key);
            if (collector == null) {
                collector = new TimedDataCollector(key);
                collector.setPaused(this.pauseAllCollectors.get());
                this.collectors.put(key, collector);
            }
        } else {
            collector = parent.getChild(key);
            if (collector == null) {
                collector = new TimedDataCollector(key);
                collector.setPaused(this.pauseAllCollectors.get());
                parent.addChild(key, collector);
            }
        }
        return collector;
    }

    Map<String, DataCollector> getRootCollectors() {
        return Collections.unmodifiableMap(this.collectors);
    }

    synchronized void setPaused(boolean paused) {
        this.pauseAllCollectors.set(paused);
        this.collectors.values().forEach(collector -> collector.setPaused(paused));
    }

    public void warn(String msg) {
        if (!this.pauseAllCollectors.get()) {
            System.err.println("WARNING: " + msg);
        }
    }
}

