/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.types.util;

public enum Variance {
    CO,
    CONTRA,
    INV;


    public Variance inverse() {
        switch (this) {
            case CO: {
                return CONTRA;
            }
            case CONTRA: {
                return CO;
            }
            case INV: {
                return INV;
            }
        }
        throw new UnsupportedOperationException("unsupported literal: " + (Object)((Object)this));
    }

    public Variance mult(Variance other) {
        if (this == INV || other == INV) {
            return INV;
        }
        if (this == CONTRA && other == CONTRA) {
            return CO;
        }
        if (this == CONTRA || other == CONTRA) {
            return CONTRA;
        }
        if (this == CO && other == CO) {
            return CO;
        }
        throw new UnsupportedOperationException("unsupported literals: " + (Object)((Object)this) + ", " + (Object)((Object)other));
    }

    public String getDescriptiveString(boolean inOutHint) {
        switch (this) {
            case CO: {
                return inOutHint ? "covariant (out)" : "covariant";
            }
            case CONTRA: {
                return inOutHint ? "contravariant (in)" : "contravariant";
            }
            case INV: {
                return "invariant";
            }
        }
        throw new UnsupportedOperationException("unsupported literal: " + (Object)((Object)this));
    }

    public String getDescriptiveStringNoun(boolean inOutHint) {
        switch (this) {
            case CO: {
                return inOutHint ? "covariance (out)" : "covariance";
            }
            case CONTRA: {
                return inOutHint ? "contravariance (in)" : "contravariance";
            }
            case INV: {
                return "invariance";
            }
        }
        throw new UnsupportedOperationException("unsupported literal: " + (Object)((Object)this));
    }

    public String getRelationString() {
        if (this == CO) {
            return "<:";
        }
        if (this == CONTRA) {
            return ":>";
        }
        return "=";
    }
}

