/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs;

import java.util.LinkedList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.AbstractCaseClause;
import org.eclipse.n4js.n4JS.AnnotationArgument;
import org.eclipse.n4js.n4JS.BindingPattern;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.CatchBlock;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.DoStatement;
import org.eclipse.n4js.n4JS.ExportDeclaration;
import org.eclipse.n4js.n4JS.ExportSpecifier;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.FieldAccessor;
import org.eclipse.n4js.n4JS.ForStatement;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.IfStatement;
import org.eclipse.n4js.n4JS.LiteralOrComputedPropertyName;
import org.eclipse.n4js.n4JS.N4ClassDefinition;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.SwitchStatement;
import org.eclipse.n4js.n4JS.TryStatement;
import org.eclipse.n4js.n4JS.WhileStatement;
import org.eclipse.n4js.n4JS.WithStatement;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class FGUtils {
    public static String getSourceText(EObject eo) {
        ICompositeNode actualNode = NodeModelUtils.findActualNodeFor((EObject)eo);
        String text = NodeModelUtils.getTokenText((INode)actualNode);
        return text;
    }

    public static String getNameID(EObject cfe) {
        String className = FGUtils.getClassName(cfe);
        String nameID = String.valueOf(className) + "#" + cfe.hashCode();
        return nameID;
    }

    public static String getClassName(EObject cfe) {
        String className = cfe.getClass().getSimpleName().toString();
        int idx = className.lastIndexOf("Impl");
        if (idx == className.length() - "Impl".length()) {
            className = className.substring(0, idx);
        }
        return className;
    }

    public static ControlFlowElement getCFContainer(ControlFlowElement cfe) {
        ControlFlowElement curCFE = cfe;
        while (curCFE != null) {
            if (FGUtils.isCFContainer((EObject)curCFE)) {
                return curCFE;
            }
            curCFE = FGUtils.getContainer(curCFE);
        }
        throw new IllegalArgumentException("Could not find Container for: " + cfe.toString());
    }

    private static ControlFlowElement getContainer(ControlFlowElement curCFE) {
        ControlFlowElement eObj = curCFE;
        while ((eObj = eObj.eContainer()) != null && !(eObj instanceof ControlFlowElement)) {
        }
        curCFE = eObj;
        return curCFE;
    }

    public static boolean isCFContainer(EObject cfe) {
        boolean isScript = cfe instanceof Script;
        boolean isBlock = cfe instanceof Block;
        boolean isExpression = cfe instanceof Expression;
        boolean isBindingPattern = cfe instanceof BindingPattern;
        if (!(isScript || isBlock || isExpression || isBindingPattern)) {
            return false;
        }
        EObject cfeContainer = cfe.eContainer();
        EObject cfeContainer2 = cfeContainer == null ? null : cfeContainer.eContainer();
        boolean containerIsFunctionDeclaration = cfeContainer instanceof FunctionDeclaration;
        boolean containerIsFunctionDefinition = cfeContainer instanceof FunctionDefinition;
        boolean containerIsFieldAccessor = cfeContainer instanceof FieldAccessor;
        boolean containerIsFormalParameter = cfeContainer instanceof FormalParameter;
        boolean containerIsFieldDeclaration = cfeContainer instanceof N4FieldDeclaration;
        boolean containerIsAnnotationArgument = cfeContainer instanceof AnnotationArgument;
        boolean containerIsLiteralOrComputedPropertyName = cfeContainer instanceof LiteralOrComputedPropertyName;
        boolean containerIsExportSpecifier = cfeContainer instanceof ExportSpecifier;
        boolean containerIsExportDeclaration = cfeContainer instanceof ExportDeclaration;
        boolean containerIsN4ClassDefinition = cfeContainer instanceof N4ClassDefinition;
        boolean container2IsN4FieldDeclaration = cfeContainer2 instanceof N4FieldDeclaration;
        boolean isCFContainer = false;
        isCFContainer |= isScript;
        isCFContainer |= isBlock && containerIsFunctionDeclaration;
        isCFContainer |= isBlock && containerIsFunctionDefinition;
        isCFContainer |= isBlock && containerIsFieldAccessor;
        isCFContainer |= isBindingPattern && containerIsFormalParameter;
        isCFContainer |= isExpression && containerIsFormalParameter;
        isCFContainer |= isExpression && containerIsFieldDeclaration;
        isCFContainer |= isExpression && containerIsAnnotationArgument;
        isCFContainer |= isExpression && containerIsLiteralOrComputedPropertyName && container2IsN4FieldDeclaration;
        isCFContainer |= isExpression && containerIsN4ClassDefinition;
        isCFContainer |= isExpression && containerIsExportSpecifier;
        return isCFContainer |= isExpression && containerIsExportDeclaration;
    }

    public static boolean isControlStatement(ControlFlowElement cfe) {
        boolean isControlStatement = false;
        isControlStatement |= cfe instanceof AbstractCaseClause;
        isControlStatement |= cfe instanceof Block;
        isControlStatement |= cfe instanceof DoStatement;
        isControlStatement |= cfe instanceof ForStatement;
        isControlStatement |= cfe instanceof IfStatement;
        isControlStatement |= cfe instanceof SwitchStatement;
        isControlStatement |= cfe instanceof TryStatement;
        isControlStatement |= cfe instanceof WhileStatement;
        return isControlStatement |= cfe instanceof WithStatement;
    }

    public static <T> LinkedList<T> getAllContainersOfTypeUptoCFContainer(ControlFlowElement cfe, Class<T> clazz) {
        LinkedList<ControlFlowElement> results = new LinkedList<ControlFlowElement>();
        ControlFlowElement curCFE = cfe;
        while (curCFE != null && !FGUtils.isCFContainer((EObject)curCFE)) {
            if (clazz.isAssignableFrom(curCFE.getClass())) {
                results.add(curCFE);
            }
            curCFE = FGUtils.getContainer(curCFE);
        }
        return results;
    }

    public static Block getCatchBlock(ControlFlowElement cfe) {
        LinkedList<Block> mightBeInCatchBlock = FGUtils.getAllContainersOfTypeUptoCFContainer(cfe, Block.class);
        for (Block block : mightBeInCatchBlock) {
            if (!(block.eContainer() instanceof CatchBlock)) continue;
            return block;
        }
        return null;
    }

    public static int getASTDepth(EObject eObj) {
        int i = 0;
        while (eObj != null) {
            eObj = eObj.eContainer();
            ++i;
        }
        return i;
    }
}

