/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.model;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.xpect.Environment;
import org.eclipse.xpect.XjmClass;
import org.eclipse.xpect.XjmContribution;
import org.eclipse.xpect.XjmElement;
import org.eclipse.xpect.XjmMethod;
import org.eclipse.xpect.XjmTest;
import org.eclipse.xpect.XpectContributionRole;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.XpectJavaModelFactory;
import org.eclipse.xpect.XpectReplace;
import org.eclipse.xpect.model.XjmContributionImplCustom;
import org.eclipse.xpect.model.XjmTestImplCustom;
import org.eclipse.xpect.model.XpectJavaModelImpl;
import org.eclipse.xpect.runner.Xpect;
import org.eclipse.xpect.runner.XpectSuiteClasses;
import org.eclipse.xpect.setup.XpectSetup;
import org.eclipse.xpect.util.JvmAnnotationUtil;
import org.eclipse.xpect.util.JvmTypesUtil;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeAnnotationValue;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.junit.Test;
import org.junit.runner.RunWith;

public class XpectJavaModelImplCustom
extends XpectJavaModelImpl {
    private boolean contributionsInitialized = false;
    private boolean methodsInitialized = false;
    private boolean testsInitalized = false;

    private void collectContributions(JvmAnnotationTarget ctx, XjmElement owner, Map<String, XjmContribution> contributions, Set<Object> visited) {
        if (ctx == null || ctx.eIsProxy() || !visited.add(Tuples.create((Object)ctx, (Object)owner))) {
            return;
        }
        XjmContribution contribution = null;
        if (ctx instanceof JvmDeclaredType) {
            List<? extends Annotation> roles;
            String qualifiedName = ctx.getQualifiedName();
            contribution = contributions.get(qualifiedName);
            if (contribution == null && !(roles = JvmAnnotationUtil.getJavaAnnotationsViaMetaAnnotation(ctx, XpectContributionRole.class)).isEmpty()) {
                contribution = XpectJavaModelFactory.eINSTANCE.createXjmContribution();
                ((XjmContributionImplCustom)contribution).initialize((JvmDeclaredType)ctx, roles);
                contributions.put(qualifiedName, contribution);
            }
            if (contribution != null && owner != null) {
                owner.getImports().add((Object)contribution);
            }
        }
        LinkedHashSet targets = Sets.newLinkedHashSet();
        targets.add(ctx);
        if (ctx instanceof JvmDeclaredType) {
            for (JvmType superType : JvmTypesUtil.getAllSuperTypes((JvmDeclaredType)ctx)) {
                if (!(superType instanceof JvmAnnotationTarget)) continue;
                targets.add((JvmAnnotationTarget)superType);
            }
        }
        LinkedHashSet imports = Sets.newLinkedHashSet();
        for (JvmAnnotationTarget target : targets) {
            imports.addAll(JvmAnnotationUtil.getAnnotationTypeValue(target, XpectImport.class));
            imports.addAll(JvmAnnotationUtil.getAnnotationTypeValue(target, XpectReplace.class));
            imports.addAll(JvmAnnotationUtil.getAnnotationTypeValue(target, XpectSetup.class));
        }
        XjmElement newOwner = contribution == null ? owner : contribution;
        for (JvmDeclaredType imp : imports) {
            this.collectContributions((JvmAnnotationTarget)imp, newOwner, contributions, visited);
        }
    }

    private void collectContributions(XjmClass owner, Map<String, XjmContribution> contribution, Set<Object> visited) {
        this.collectContributions((JvmAnnotationTarget)owner.getJvmClass(), owner, contribution, visited);
    }

    private void collectTestClasses(JvmDeclaredType classOrSuite, Map<String, XjmTest> result) {
        JvmTypeAnnotationValue typeValue = JvmAnnotationUtil.getAnnotationValue((JvmAnnotationTarget)classOrSuite, XpectSuiteClasses.class, JvmTypeAnnotationValue.class);
        if (typeValue != null) {
            for (JvmTypeReference ref : typeValue.getValues()) {
                String name;
                XjmTest cls;
                JvmType jvmType;
                if (ref == null || ref.eIsProxy() || !((jvmType = ref.getType()) instanceof JvmDeclaredType) || jvmType.eIsProxy() || (cls = result.get(name = jvmType.getQualifiedName())) != null) continue;
                JvmDeclaredType jvmDeclaredType = (JvmDeclaredType)jvmType;
                cls = XpectJavaModelFactory.eINSTANCE.createXjmTest();
                cls.setJvmClass(jvmDeclaredType);
                result.put(name, cls);
                this.collectTestClasses(jvmDeclaredType, result);
            }
        }
    }

    private Multimap<XjmClass, String> computeReverseImports() {
        LinkedHashMultimap result = LinkedHashMultimap.create();
        ArrayList elements = Lists.newArrayList(this.getTests());
        elements.addAll(this.getTests());
        elements.addAll(this.getMethods().values());
        elements.addAll(this.getContributions());
        for (XjmElement cnt : elements) {
            for (XjmClass imported : cnt.getImports()) {
                result.put((Object)imported, (Object)this.toSimpleName(cnt));
            }
        }
        return result;
    }

    @Override
    public EList<XjmContribution> getContributions() {
        if (!this.contributionsInitialized) {
            this.initContributions();
            this.contributionsInitialized = true;
        }
        return super.getContributions();
    }

    @Override
    public EMap<String, XjmMethod> getMethods() {
        if (!this.methodsInitialized) {
            this.initTestClassMethods();
            this.methodsInitialized = true;
        }
        return super.getMethods();
    }

    @Override
    public EList<XjmTest> getTests() {
        if (!this.testsInitalized) {
            this.initTestClasses();
            this.testsInitalized = true;
        }
        return super.getTests();
    }

    private void initContributions() {
        HashSet visited = Sets.newHashSet();
        LinkedHashMap contributions = Maps.newLinkedHashMap();
        XjmTest root = this.getTestOrSuite();
        List<JvmDeclaredType> runners = JvmAnnotationUtil.getAnnotationTypeValue((JvmAnnotationTarget)root.getJvmClass(), RunWith.class);
        for (JvmDeclaredType runner : runners) {
            this.collectContributions((JvmAnnotationTarget)runner, root, contributions, visited);
        }
        for (XjmTest test : this.getTests()) {
            this.collectContributions(test, contributions, visited);
            for (XjmMethod method : test.getMethods()) {
                JvmOperation jvmMethod = method.getJvmMethod();
                if (jvmMethod == null || jvmMethod.eIsProxy()) continue;
                for (JvmAnnotationReference ref : jvmMethod.getAnnotations()) {
                    this.collectContributions((JvmAnnotationTarget)ref.getAnnotation(), method, contributions, visited);
                }
                for (JvmFormalParameter param : jvmMethod.getParameters()) {
                    JvmType type;
                    for (JvmAnnotationReference ref : param.getAnnotations()) {
                        this.collectContributions((JvmAnnotationTarget)ref.getAnnotation(), method, contributions, visited);
                    }
                    JvmTypeReference typeRef = param.getParameterType();
                    if (typeRef == null || typeRef.eIsProxy() || !((type = typeRef.getType()) instanceof JvmAnnotationTarget) || type.eIsProxy()) continue;
                    this.collectContributions((JvmAnnotationTarget)type, method, contributions, visited);
                }
            }
        }
        EList<XjmContribution> newContributions = super.getContributions();
        newContributions.clear();
        newContributions.addAll(contributions.values());
        this.initSubstitutions((Collection<XjmContribution>)newContributions);
    }

    private void initSubstitutions(Collection<XjmContribution> contributions) {
        HashMap contributionsByType = Maps.newHashMap();
        for (XjmContribution cont : contributions) {
            JvmDeclaredType jvmClass;
            if (!cont.isActive() || (jvmClass = cont.getJvmClass()) == null || jvmClass.eIsProxy()) continue;
            contributionsByType.put(jvmClass, cont);
        }
        for (XjmContribution cont : contributionsByType.values()) {
            List<JvmDeclaredType> replaces = JvmAnnotationUtil.getAnnotationTypeValue((JvmAnnotationTarget)cont.getJvmClass(), XpectReplace.class);
            for (JvmDeclaredType replace : replaces) {
                XjmContribution replaced = (XjmContribution)contributionsByType.get(replace);
                if (replaced == null) continue;
                replaced.setReplacedBy(cont);
            }
        }
    }

    private void initTestClasses() {
        JvmDeclaredType jvmClass;
        LinkedHashMap name2test = Maps.newLinkedHashMap();
        XjmTest test = this.getTestOrSuite();
        EList<XjmTest> newTests = super.getTests();
        newTests.clear();
        if (test != null && !test.eIsProxy() && (jvmClass = test.getJvmClass()) != null && !jvmClass.eIsProxy()) {
            name2test.put(jvmClass.getQualifiedName(), test);
            this.collectTestClasses(test.getJvmClass(), name2test);
            newTests.addAll(name2test.values());
        }
    }

    private void initTestClassMethods() {
        LinkedHashMultimap xpectMethods = LinkedHashMultimap.create();
        for (XjmTest type : this.getTests()) {
            for (JvmFeature feature : type.getJvmClass().getAllFeatures()) {
                if (!(feature instanceof JvmOperation) || feature.getVisibility() != JvmVisibility.PUBLIC) continue;
                if (JvmAnnotationUtil.isAnnotatedWith((JvmAnnotationTarget)feature, Xpect.class)) {
                    xpectMethods.put((Object)Tuples.create((Object)true, (Object)feature.getSimpleName()), (Object)Tuples.create((Object)type, (Object)((JvmOperation)feature)));
                }
                if (!JvmAnnotationUtil.isAnnotatedWith((JvmAnnotationTarget)feature, Test.class)) continue;
                xpectMethods.put((Object)Tuples.create((Object)false, (Object)feature.getSimpleName()), (Object)Tuples.create((Object)type, (Object)((JvmOperation)feature)));
            }
        }
        XpectJavaModelFactory factory = XpectJavaModelFactory.eINSTANCE;
        EMap<String, XjmMethod> name2method = super.getMethods();
        for (Map.Entry e : xpectMethods.asMap().entrySet()) {
            if (((Collection)e.getValue()).size() != 1) continue;
            Pair pair = (Pair)((Collection)e.getValue()).iterator().next();
            XjmMethod method = (Boolean)((Pair)e.getKey()).getFirst() != false ? factory.createXjmXpectMethod() : factory.createXjmTestMethod();
            method.setJvmMethod((JvmOperation)pair.getSecond());
            ((XjmTestImplCustom)pair.getFirst()).addMethod(method);
            name2method.put((Object)method.getName(), (Object)method);
        }
    }

    private String toQualifiedName(JvmIdentifiableElement element) {
        if (element == null) {
            return "null";
        }
        if (element.eIsProxy()) {
            return "Proxy: " + ((InternalEObject)element).eProxyURI();
        }
        String name = element.getQualifiedName();
        return name == null ? "null" : name;
    }

    private String toSimpleName(XjmElement element) {
        if (element instanceof XjmMethod) {
            JvmOperation method = ((XjmMethod)element).getJvmMethod();
            if (method == null) {
                return null;
            }
            if (method.eIsProxy()) {
                return "Proxy: " + ((InternalEObject)method).eProxyURI();
            }
            JvmDeclaredType type = method.getDeclaringType();
            return String.valueOf(type.getSimpleName()) + "." + method.getSimpleName() + "()";
        }
        if (element instanceof XjmClass) {
            JvmDeclaredType jvmClass = ((XjmClass)element).getJvmClass();
            if (jvmClass == null) {
                return null;
            }
            if (jvmClass.eIsProxy()) {
                return "Proxy: " + ((InternalEObject)jvmClass).eProxyURI();
            }
            return jvmClass.getSimpleName();
        }
        return element == null ? "null" : element.toString();
    }

    public String toString() {
        Multimap<XjmClass, String> reverseImports = this.computeReverseImports();
        HashMultimap contributionByRole = HashMultimap.create();
        for (XjmContribution cnt : this.getContributions()) {
            for (Annotation role : cnt.getRoles()) {
                contributionByRole.put((Object)role.annotationType().getSimpleName(), (Object)cnt);
            }
        }
        ArrayList items = Lists.newArrayList();
        items.addAll(this.getTests());
        for (Map.Entry e : contributionByRole.asMap().entrySet()) {
            items.add(this.toString((String)e.getKey(), (Collection)e.getValue(), reverseImports));
        }
        String body = " {\n  " + Joiner.on((String)"\n").join((Iterable)items).replace("\n", "\n  ") + "\n}";
        return "suite " + this.toQualifiedName((JvmIdentifiableElement)this.getTestOrSuite().getJvmClass()) + body;
    }

    private String toString(String role, Collection<XjmContribution> contributions, Multimap<XjmClass, String> reverseImports) {
        ArrayList items = Lists.newArrayList();
        for (XjmContribution cnt : contributions) {
            items.add(this.toString(cnt, reverseImports.get((Object)cnt)));
        }
        Collections.sort(items);
        String body = " {\n  " + Joiner.on((String)"\n").join((Iterable)items).replace("\n", "\n  ") + "\n}";
        return "contributionsFor @" + role + body;
    }

    private String toString(XjmContribution contribution, Collection<String> importedBy) {
        StringBuilder result = new StringBuilder();
        if (!contribution.isActive()) {
            result.append("[INACTIVE] ");
        }
        result.append(this.toQualifiedName((JvmIdentifiableElement)contribution.getJvmClass()));
        String reason = contribution.getDeactivationReason();
        if (reason != null) {
            result.append(" InactiveBecause: ");
            result.append(reason);
        }
        if (!importedBy.isEmpty()) {
            result.append(" ImportedBy:");
            result.append(Joiner.on((String)" ").join(importedBy));
        }
        return result.toString();
    }

    @Override
    public Iterable<XjmContribution> getContributions(Class<? extends Annotation> role) {
        ArrayList list = Lists.newArrayList();
        block0: for (XjmContribution cont : this.getContributions()) {
            for (Annotation cand : cont.getRoles()) {
                if (cand.annotationType() != role) continue;
                list.add(cont);
                continue block0;
            }
        }
        return list;
    }

    @Override
    public Iterable<XjmContribution> getContributions(Class<? extends Annotation> role, Environment environment) {
        ArrayList list = Lists.newArrayList();
        block0: for (XjmContribution cont : this.getContributions()) {
            if (!cont.getEnvironments().contains((Object)environment)) continue;
            for (Annotation cand : cont.getRoles()) {
                if (cand.annotationType() != role) continue;
                list.add(cont);
                continue block0;
            }
        }
        return list;
    }
}

