/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.postprocessing.ASTFlowInfo;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.smith.Measurement;
import org.eclipse.n4js.smith.N4JSDataCollectors;
import org.eclipse.n4js.utils.FindReferenceHelper;
import org.eclipse.n4js.validation.AbstractN4JSDeclarativeValidator;
import org.eclipse.n4js.validation.validators.flowgraphs.DeadCodeValidator;
import org.eclipse.n4js.validation.validators.flowgraphs.FlowValidator;
import org.eclipse.n4js.validation.validators.flowgraphs.MissingReturnOrThrowValidator;
import org.eclipse.n4js.validation.validators.flowgraphs.NullUndefinedValidator;
import org.eclipse.n4js.validation.validators.flowgraphs.UsedBeforeDeclaredValidator;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CancelableDiagnostician;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class N4JSFlowgraphValidator
extends AbstractN4JSDeclarativeValidator {
    @Inject
    private OperationCanceledManager operationCanceledManager;
    @Inject
    private FindReferenceHelper findReferenceHelper;
    @Inject
    private IN4JSCore n4jsCore;

    public void register(EValidatorRegistrar registrar) {
    }

    private Void checkCancelled() {
        CancelIndicator cancelIndicator = (CancelIndicator)this.getContext().get(CancelableDiagnostician.CANCEL_INDICATOR);
        this.operationCanceledManager.checkCanceled(cancelIndicator);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Check
    public void checkFlowGraphs(Script script) {
        ASTFlowInfo flowInfo;
        block15: {
            N4JSResource resource = (N4JSResource)script.eResource();
            flowInfo = resource.getASTMetaInfoCache().getFlowInfo();
            if (!flowInfo.canPerformBackwardAnalysis()) {
                return;
            }
            flowInfo.performBackwardAnalysis(this::checkCancelled);
            FlowValidator[] fValidators = new FlowValidator[]{new DeadCodeValidator(flowInfo.deadCodeAnalyser, this.keywordProvider), new UsedBeforeDeclaredValidator(flowInfo.usedBeforeDeclaredAnalyser), new NullUndefinedValidator(flowInfo.nullDereferenceAnalyser, this.n4jsCore, this.findReferenceHelper), new MissingReturnOrThrowValidator(flowInfo.missingReturnOrThrowAnalyser)};
            String uriString = script.eResource().getURI().toString();
            Throwable throwable = null;
            Object var8_8 = null;
            try {
                Measurement m1 = N4JSDataCollectors.dcFlowGraphs.getMeasurement("flowGraphs_" + uriString);
                try {
                    try (Measurement m2 = N4JSDataCollectors.dcFlowGraphPostprocessing.getMeasurement("createGraph_" + uriString);){
                        FlowValidator[] flowValidatorArray = fValidators;
                        int n = fValidators.length;
                        int n2 = 0;
                        while (n2 < n) {
                            FlowValidator fValidator = flowValidatorArray[n2];
                            fValidator.checkResults(this);
                            ++n2;
                        }
                    }
                    if (m1 == null) break block15;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (m1 == null) throw throwable;
                    m1.close();
                    throw throwable;
                }
                m1.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        flowInfo.reset();
    }

    public void addIssue(String message, EObject source, String issueCode) {
        super.addIssue(message, source, issueCode);
    }

    public void addIssue(String message, EObject source, int offset, int length, String issueCode) {
        super.addIssue(message, source, offset, length, issueCode);
    }

    public void addIssue(String message, EObject source, EStructuralFeature feature, String issueCode, String ... issueData) {
        super.addIssue(message, source, feature, issueCode, issueData);
    }
}

