/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.transpiler.utils.TranspilerUtils;

public class Tracer {
    private final Map<EObject, EObject> im2ast = new HashMap<EObject, EObject>();
    private final Map<EObject, Set<EObject>> ast2im = new HashMap<EObject, Set<EObject>>();

    public boolean isEmpty() {
        return this.im2ast.isEmpty();
    }

    public boolean containsKey(EObject elementInIntermediateModel) {
        return this.im2ast.containsKey(elementInIntermediateModel);
    }

    public boolean containsValue(EObject originalASTNode) {
        return this.im2ast.containsValue(originalASTNode);
    }

    public <T extends EObject> T getOriginalASTNodeOfSameType(T elementInIM, boolean failFast) {
        EObject original = this.getOriginalASTNode(elementInIM);
        if (original != null && original.eClass() == elementInIM.eClass()) {
            EObject originalCasted = original;
            return (T)originalCasted;
        }
        if (failFast) {
            if (original != null) {
                throw new IllegalStateException("there was an original AST node, but of wrong type");
            }
            throw new IllegalStateException("no original AST node found");
        }
        return null;
    }

    public EObject getOriginalASTNode(EObject elementInIntermediateModel) {
        return this.getOriginalASTNode(elementInIntermediateModel, false);
    }

    public EObject getOriginalASTNode(EObject elementInIntermediateModel, boolean includeAncestorLinks) {
        EObject originalASTNode;
        TranspilerUtils.assertIntermediateModelElement(elementInIntermediateModel);
        do {
            originalASTNode = this.im2ast.get(elementInIntermediateModel);
        } while (includeAncestorLinks && originalASTNode == null && (elementInIntermediateModel = elementInIntermediateModel.eContainer()) != null);
        return originalASTNode;
    }

    public <T extends EObject> T getSingleIntermediateModelElementOfSameType(T originalASTNode, boolean failFast) {
        EObject elemInIM = this.getSingleIntermediateModelElement(originalASTNode, failFast);
        if (elemInIM != null && elemInIM.eClass() == originalASTNode.eClass()) {
            EObject elemCasted = elemInIM;
            return (T)elemCasted;
        }
        if (failFast) {
            if (elemInIM != null) {
                throw new IllegalStateException("there was an element in the intermediate model, but of wrong type");
            }
            throw new IllegalStateException("no element in intermediate model found");
        }
        return null;
    }

    public EObject getSingleIntermediateModelElement(EObject originalASTNode, boolean failFast) {
        Set<EObject> elems = this.getIntermediateModelElements(originalASTNode);
        if (elems.size() == 1) {
            return elems.iterator().next();
        }
        if (failFast) {
            if (!elems.isEmpty()) {
                throw new IllegalStateException("several elements in intermediate model found");
            }
            throw new IllegalStateException("no elements in intermediate model found");
        }
        return null;
    }

    public Set<EObject> getIntermediateModelElements(EObject originalASTNode) {
        TranspilerUtils.assertOriginalASTNode(originalASTNode);
        Set<EObject> l = this.ast2im.get(originalASTNode);
        return l != null ? l : Collections.emptySet();
    }

    public void setOriginalASTNode(EObject[] elementsInIntermediateModel, EObject originalASTNode) {
        EObject[] eObjectArray = elementsInIntermediateModel;
        int n = elementsInIntermediateModel.length;
        int n2 = 0;
        while (n2 < n) {
            EObject elem = eObjectArray[n2];
            this.setOriginalASTNode(elem, originalASTNode);
            ++n2;
        }
    }

    public void setOriginalASTNode(EObject elementInIntermediateModel, EObject originalASTNode) {
        TranspilerUtils.assertIntermediateModelElement(elementInIntermediateModel);
        TranspilerUtils.assertOriginalASTNode(originalASTNode);
        this.setOriginalASTNode_internal(elementInIntermediateModel, originalASTNode);
    }

    void setOriginalASTNode_internal(EObject elementInIntermediateModel, EObject originalASTNode) {
        this.unsetOriginalASTNode_internal(elementInIntermediateModel);
        this.im2ast.put(elementInIntermediateModel, originalASTNode);
        Set<EObject> l = this.ast2im.get(originalASTNode);
        if (l == null) {
            l = new HashSet<EObject>();
            this.ast2im.put(originalASTNode, l);
        }
        l.add(elementInIntermediateModel);
    }

    public void unsetOriginalASTNode(EObject elementInIntermediateModel) {
        TranspilerUtils.assertIntermediateModelElement(elementInIntermediateModel);
        this.unsetOriginalASTNode_internal(elementInIntermediateModel);
    }

    public void discardIntermediateModelNode(EObject elementInIntermediateModel) {
        this.unsetOriginalASTNode(elementInIntermediateModel);
        this.im2ast.remove(elementInIntermediateModel);
    }

    private void unsetOriginalASTNode_internal(EObject elementInIntermediateModel) {
        Set<EObject> lOld;
        EObject oldOriginalASTNode = this.im2ast.get(elementInIntermediateModel);
        if (oldOriginalASTNode != null && (lOld = this.ast2im.get(oldOriginalASTNode)) != null) {
            lOld.remove(elementInIntermediateModel);
        }
    }

    public void copyTrace(EObject fromElementInIntermediateModel, EObject ... toElementInIntermediateModel) {
        EObject originalASTNode = this.im2ast.get(fromElementInIntermediateModel);
        if (originalASTNode == null) {
            return;
        }
        EObject[] eObjectArray = toElementInIntermediateModel;
        int n = toElementInIntermediateModel.length;
        int n2 = 0;
        while (n2 < n) {
            EObject elemInIM = eObjectArray[n2];
            this.setOriginalASTNode_internal(elemInIM, originalASTNode);
            ++n2;
        }
    }
}

