/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.n4js.utils.OSInfo;

public class ExecutableLookupUtil {
    private static String[] WIN_SHELL_COMAMNDS = new String[]{"cmd", "/c"};
    private static String[] NIX_SHELL_COMAMNDS = new String[]{"sh", "-c"};
    private static String WIN_FINDER = "where";
    private static String NIX_FINDER = "which";
    private static String PATH = "PATH";

    public static ProcessBuilder getExebutableLookupProcessBuilder(String execName) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (OSInfo.isWindows()) {
            builder.add((Object[])WIN_SHELL_COMAMNDS);
            builder.add((Object)WIN_FINDER);
            builder.add((Object)execName);
        } else {
            builder.add((Object[])NIX_SHELL_COMAMNDS);
            builder.add((Object)(String.valueOf(NIX_FINDER) + " " + execName));
        }
        ProcessBuilder processBuilder = new ProcessBuilder((List<String>)builder.build());
        processBuilder.redirectErrorStream(false);
        return processBuilder;
    }

    public static String findInPath(String exec) {
        String path = System.getenv(PATH);
        if (path == null) {
            return null;
        }
        return Pattern.compile(Pattern.quote(File.pathSeparator)).splitAsStream(path).map(string -> Paths.get(string, new String[0])).filter(p -> Files.exists(p.resolve(exec), new LinkOption[0])).findFirst().map(p -> p.toString()).orElse(null);
    }
}

