/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.analysers;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.n4js.flowgraphs.analysers.NullDereferenceAnalyser;
import org.eclipse.n4js.flowgraphs.analysers.NullDereferenceFailed;
import org.eclipse.n4js.flowgraphs.dataflow.PartialResult;
import org.eclipse.n4js.flowgraphs.dataflow.guards.GuardAssertion;
import org.eclipse.n4js.flowgraphs.dataflow.guards.GuardType;
import org.eclipse.n4js.flowgraphs.dataflow.symbols.Symbol;
import org.eclipse.n4js.n4JS.ControlFlowElement;

public class NullDereferenceResult {
    public final ControlFlowElement cfe;
    public final Symbol checkedSymbol;
    public final Symbol failedAlias;
    public final Set<GuardType> types;
    public final GuardAssertion assertion;

    NullDereferenceResult(ControlFlowElement cfe, NullDereferenceAnalyser.IsNotNull inn) {
        this.cfe = cfe;
        this.checkedSymbol = inn.symbol;
        this.failedAlias = this.getFailedSymbol(inn);
        this.types = this.getTypes(inn);
        this.assertion = this.getAssertion(inn);
    }

    private Symbol getFailedSymbol(NullDereferenceAnalyser.IsNotNull inn) {
        if (inn.failedBranches.isEmpty()) {
            return null;
        }
        HashSet<Symbol> failedSymbols = new HashSet<Symbol>();
        for (PartialResult result : inn.failedBranches) {
            NullDereferenceFailed ndFailed = (NullDereferenceFailed)result;
            failedSymbols.add(ndFailed.symbol);
        }
        if (failedSymbols.size() == 1) {
            return (Symbol)failedSymbols.iterator().next();
        }
        return null;
    }

    private Set<GuardType> getTypes(NullDereferenceAnalyser.IsNotNull inn) {
        if (inn.terminatingGuard != null) {
            NullDereferenceFailed ndFailed = (NullDereferenceFailed)inn.terminatingGuard;
            return Sets.newHashSet((Object[])new GuardType[]{ndFailed.expectation});
        }
        if (!inn.failedBranches.isEmpty()) {
            TreeSet<GuardType> results = new TreeSet<GuardType>();
            for (PartialResult result : inn.failedBranches) {
                NullDereferenceFailed ndFailed = (NullDereferenceFailed)result;
                results.add(ndFailed.expectation);
            }
            return results;
        }
        return Collections.emptySet();
    }

    private GuardAssertion getAssertion(NullDereferenceAnalyser.IsNotNull inn) {
        if (inn.passedBranches.isEmpty() && inn.aliases.isEmpty()) {
            boolean oneMayFailed = false;
            for (PartialResult pr : inn.failedBranches) {
                oneMayFailed |= pr.type == PartialResult.Type.MayFailed;
            }
            if (oneMayFailed) {
                return GuardAssertion.MayHolds;
            }
            return GuardAssertion.AlwaysHolds;
        }
        if (inn.terminatingGuard != null) {
            if (inn.terminatingGuard.type == PartialResult.Type.MayFailed) {
                return GuardAssertion.MayHolds;
            }
            return GuardAssertion.AlwaysHolds;
        }
        return GuardAssertion.MayHolds;
    }

    public int hashCode() {
        return this.cfe.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof NullDereferenceResult)) {
            return false;
        }
        NullDereferenceResult ndr = (NullDereferenceResult)o;
        return this.cfe.equals(ndr.cfe);
    }
}

