/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es.assistants;

import java.util.List;
import org.eclipse.n4js.n4JS.ArrayBindingPattern;
import org.eclipse.n4js.n4JS.ArrayElement;
import org.eclipse.n4js.n4JS.ArrayLiteral;
import org.eclipse.n4js.n4JS.BindingElement;
import org.eclipse.n4js.n4JS.BindingPattern;
import org.eclipse.n4js.n4JS.BindingProperty;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.ObjectBindingPattern;
import org.eclipse.n4js.n4JS.ObjectLiteral;
import org.eclipse.n4js.n4JS.PrimaryExpression;
import org.eclipse.n4js.n4JS.PropertyAssignment;
import org.eclipse.n4js.n4JS.PropertyNameValuePair;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.transpiler.TransformationAssistant;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class DestructuringAssistant
extends TransformationAssistant {
    public PrimaryExpression convertBindingPatternToArrayOrObjectLiteral(BindingPattern binding) {
        ArrayLiteral _switchResult = null;
        boolean _matched = false;
        if (binding instanceof ArrayBindingPattern) {
            _matched = true;
            _switchResult = this.convertArrayBindingPatternToArrayLiteral((ArrayBindingPattern)binding);
        }
        if (!_matched && binding instanceof ObjectBindingPattern) {
            _matched = true;
            _switchResult = this.convertObjectBindingPatternToObjectLiteral((ObjectBindingPattern)binding);
        }
        return _switchResult;
    }

    public ArrayLiteral convertArrayBindingPatternToArrayLiteral(ArrayBindingPattern binding) {
        Functions.Function1 _function = it -> this.convertBindingElementToArrayElement((BindingElement)it);
        return TranspilerBuilderBlocks._ArrLit((ArrayElement[])((ArrayElement[])Conversions.unwrapArray((Object)ListExtensions.map((List)binding.getElements(), (Functions.Function1)_function), ArrayElement.class)));
    }

    public ObjectLiteral convertObjectBindingPatternToObjectLiteral(ObjectBindingPattern binding) {
        Functions.Function1 _function = it -> this.convertBindingPropertyToPropertyNameValuePair((BindingProperty)it);
        return TranspilerBuilderBlocks._ObjLit((PropertyAssignment[])((PropertyAssignment[])Conversions.unwrapArray((Object)ListExtensions.map((List)binding.getProperties(), (Functions.Function1)_function), PropertyAssignment.class)));
    }

    private ArrayElement convertBindingElementToArrayElement(BindingElement element) {
        BindingPattern nestedPattern = element.getNestedPattern();
        VariableDeclaration varDecl = element.getVarDecl();
        PrimaryExpression lhs = null;
        Expression rhs = null;
        if (nestedPattern != null) {
            lhs = this.convertBindingPatternToArrayOrObjectLiteral(nestedPattern);
            rhs = element.getExpression();
        } else if (varDecl != null) {
            SymbolTableEntry ste_varDecl = this.findSymbolTableEntryForElement((NamedElement)varDecl, true);
            lhs = TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)ste_varDecl);
            rhs = varDecl.getExpression();
        } else {
            return TranspilerBuilderBlocks._ArrayPadding();
        }
        boolean _isRest = element.isRest();
        Object _xifexpression = null;
        _xifexpression = rhs != null ? TranspilerBuilderBlocks._AssignmentExpr((Expression)lhs, (Expression)rhs) : lhs;
        return TranspilerBuilderBlocks._ArrayElement((boolean)_isRest, (Expression)_xifexpression);
    }

    private PropertyNameValuePair convertBindingPropertyToPropertyNameValuePair(BindingProperty property) {
        return TranspilerBuilderBlocks._PropertyNameValuePair((String)property.getName(), (Expression)this.convertBindingElementToArrayElement(property.getValue()).getExpression());
    }
}

