/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.xtext.lib.setup;

import com.google.inject.Injector;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xpect.XpectFile;
import org.eclipse.xpect.XpectJavaModel;
import org.eclipse.xpect.runner.IXpectURIProvider;
import org.eclipse.xpect.setup.XpectSetupFactory;
import org.eclipse.xpect.state.Creates;
import org.eclipse.xpect.state.StateContainer;
import org.eclipse.xpect.util.IXtInjectorProvider;
import org.eclipse.xtext.resource.IResourceFactory;

@XpectSetupFactory
public class FileSetupContext {
    private final StateContainer state;
    private final XpectFile xpectFile;

    public FileSetupContext(StateContainer state, XpectFile xpectFile) {
        this.state = state;
        this.xpectFile = xpectFile;
    }

    @Creates
    public FileSetupContext create() {
        return this;
    }

    public <T> T get(Class<T> expectedType, Object ... annotations) {
        return (T)this.state.get(expectedType, annotations).get();
    }

    public StateContainer getState() {
        return this.state;
    }

    public XpectFile getXpectFile() {
        return this.xpectFile;
    }

    public URI getXpectFileURI() {
        return this.xpectFile.eResource().getURI();
    }

    public Resource load(ResourceSet resourceSet, URI uri, InputStream input) throws IOException {
        Injector injector = IXtInjectorProvider.INSTANCE.getInjector(this.get(XpectJavaModel.class, new Object[0]), uri);
        Resource resource = ((IResourceFactory)injector.getInstance(IResourceFactory.class)).createResource(uri);
        resourceSet.getResources().add((Object)resource);
        try {
            resource.load(input, null);
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
        return resource;
    }

    public URI resolve(String uri) {
        return this.get(IXpectURIProvider.class, new Object[0]).resolveURI(this.getXpectFileURI(), uri);
    }

    public String toString() {
        return this.xpectFile.toString();
    }
}

