/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.scoping.builtin;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInSchemeRegistrar;
import org.eclipse.n4js.xtext.resourceset.EmptyAuthorityAddingNormalizer;
import org.eclipse.n4js.xtext.resourceset.XtextResourceLocator;
import org.eclipse.xtext.resource.SynchronizedXtextResourceSet;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.UriExtensions;

@Singleton
public class ResourceSetWithBuiltInSchemeProvider {
    private final ResourceSet resourceSet;

    @Inject
    public ResourceSetWithBuiltInSchemeProvider(BuiltInSchemeRegistrar registrar, ClassLoader classLoader, UriExtensions uriExtensions) {
        SynchronizedXtextResourceSet resourceSet = new SynchronizedXtextResourceSet();
        this.attachXtextResourceLocator(resourceSet);
        resourceSet.setClasspathURIContext((Object)classLoader);
        registrar.registerScheme((ResourceSet)resourceSet);
        resourceSet.setURIConverter((URIConverter)new EmptyAuthorityAddingNormalizer(resourceSet.getURIConverter(), uriExtensions));
        this.resourceSet = resourceSet;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    private ResourceSetImpl.ResourceLocator attachXtextResourceLocator(SynchronizedXtextResourceSet resourceSet) {
        return new XtextResourceLocator((XtextResourceSet)resourceSet);
    }
}

