/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.function.Function;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.tester.TestDiscoveryHelper;
import org.eclipse.n4js.tester.TestTreeTransformer;
import org.eclipse.n4js.tester.domain.TestTree;

public class TestCatalogSupplier {
    @Inject
    private ObjectMapper objectMapper;
    @Inject
    private TestTreeTransformer treeTransformer;
    @Inject
    private TestDiscoveryHelper testDiscoveryHelper;

    public String get() {
        ResourceSet resourceSet = this.testDiscoveryHelper.newResourceSet();
        return this.get(any -> resourceSet, false);
    }

    public String get(boolean suppressEndpointProperty) {
        ResourceSet resourceSet = this.testDiscoveryHelper.newResourceSet();
        return this.get(any -> resourceSet, suppressEndpointProperty);
    }

    public String get(Function<? super URI, ? extends ResourceSet> resourceSetAccess) {
        return this.get(resourceSetAccess, false);
    }

    public String get(Function<? super URI, ? extends ResourceSet> resourceSetAccess, boolean suppressEndpointProperty) {
        try {
            TestTree testTree = this.getTreeForAllTests(resourceSetAccess);
            Object testCatalogObject = suppressEndpointProperty ? this.treeTransformer.apply(testTree, Collections.emptyMap()) : this.treeTransformer.apply(testTree);
            return this.objectMapper.writeValueAsString(testCatalogObject);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error while assembling test catalog.", e);
        }
    }

    protected TestTree getTreeForAllTests(Function<? super URI, ? extends ResourceSet> resourceSetAccess) {
        return this.testDiscoveryHelper.collectAllTestsFromWorkspace(resourceSetAccess);
    }
}

