/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.n4idl.scoping;

import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4idl.versioning.VersionUtils;
import org.eclipse.n4js.scoping.utils.AbstractDescriptionWithError;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.n4js.validation.ValidatorMessageHelper;
import org.eclipse.n4js.xtext.scoping.FilteringScope;
import org.eclipse.n4js.xtext.scoping.IEObjectDescriptionWithError;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;

public class NonVersionAwareContextScope
extends FilteringScope {
    private ValidatorMessageHelper messageHelper;
    private final boolean versionAwareContextSupport;

    public NonVersionAwareContextScope(IScope parent, boolean versionAwareContextSupport, ValidatorMessageHelper messageHelper) {
        super(parent, d -> {
            EObject element = d.getEObjectOrProxy();
            if (element != null && !element.eIsProxy()) {
                return !VersionUtils.isVersionAwareContext(element);
            }
            return true;
        });
        this.messageHelper = messageHelper;
        this.versionAwareContextSupport = versionAwareContextSupport;
    }

    protected IEObjectDescriptionWithError wrapFilteredDescription(IEObjectDescription description) {
        if (!this.versionAwareContextSupport) {
            return new InvalidReferenceToVersionAwareElementDescription(description);
        }
        return new ElementOnlyReferenceFromVAContextDescription(description);
    }

    public final class ElementOnlyReferenceFromVAContextDescription
    extends AbstractDescriptionWithError {
        protected ElementOnlyReferenceFromVAContextDescription(IEObjectDescription delegate) {
            super(delegate);
        }

        public String getMessage() {
            EObject element = this.getEObjectOrProxy();
            return IssueCodes.getMessageForIDL_ELEMENT_CAN_ONLY_BE_REFERENCED_FROM_VA_CONTEXT(NonVersionAwareContextScope.this.messageHelper.description(element));
        }

        public String getIssueCode() {
            return "IDL_ELEMENT_CAN_ONLY_BE_REFERENCED_FROM_VA_CONTEXT";
        }
    }

    public final class InvalidReferenceToVersionAwareElementDescription
    extends AbstractDescriptionWithError {
        protected InvalidReferenceToVersionAwareElementDescription(IEObjectDescription delegate) {
            super(delegate);
        }

        public String getMessage() {
            EObject element = this.getEObjectOrProxy();
            return IssueCodes.getMessageForIDL_VERSION_AWARE_ELEMENT_ONLY_REF_FROM_VARIANTS(NonVersionAwareContextScope.this.messageHelper.description(element), NonVersionAwareContextScope.this.messageHelper.orList(Arrays.asList(AnnotationDefinition.VERSION_AWARE.javaScriptVariants)));
        }

        public String getIssueCode() {
            return "IDL_VERSION_AWARE_ELEMENT_ONLY_REF_FROM_VARIANTS";
        }
    }
}

