/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.json.ide.symbol;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.n4js.json.JSON.JSONDocument;
import org.eclipse.n4js.json.JSON.JSONValue;
import org.eclipse.n4js.json.JSON.NameValuePair;
import org.eclipse.xtext.ide.server.symbol.DocumentSymbolMapper;
import org.eclipse.xtext.ide.server.symbol.HierarchicalDocumentSymbolService;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;

public class JSONHierarchicalSymbolService
extends HierarchicalDocumentSymbolService {
    @Inject
    private DocumentSymbolMapper symbolMapper;
    @Inject
    private OperationCanceledManager operationCanceledManager;

    public List<Either<SymbolInformation, DocumentSymbol>> getSymbols(XtextResource resource, CancelIndicator cancelIndicator) {
        ArrayList<Either<SymbolInformation, DocumentSymbol>> result = new ArrayList<Either<SymbolInformation, DocumentSymbol>>();
        for (EObject content : resource.getContents()) {
            if (!(content instanceof JSONDocument)) continue;
            JSONDocument document = (JSONDocument)content;
            JSONValue rootValue = document.getContent();
            this.getSymbols((EObject)rootValue, symbol -> {
                boolean bl = result.add(Either.forRight((Object)symbol));
            }, cancelIndicator);
        }
        return result;
    }

    private void getSymbols(EObject value, Consumer<? super DocumentSymbol> acceptor, CancelIndicator ci) {
        this.operationCanceledManager.checkCanceled(ci);
        if (value instanceof NameValuePair) {
            NameValuePair nameValuePair = (NameValuePair)value;
            DocumentSymbol symbol = this.symbolMapper.toDocumentSymbol((EObject)nameValuePair);
            if (JSONHierarchicalSymbolService.isValid((DocumentSymbol)symbol)) {
                acceptor.accept((DocumentSymbol)symbol);
                JSONValue pairValue = ((NameValuePair)value).getValue();
                if (pairValue != null && pairValue.isContainer()) {
                    List children = symbol.getChildren();
                    this.getSymbols((EObject)pairValue, children::add, ci);
                }
            }
        } else if (value instanceof JSONValue) {
            JSONValue casted = (JSONValue)value;
            if (casted.isContainer()) {
                for (EObject child : ((JSONValue)value).getChildren()) {
                    this.getSymbols(child, acceptor, ci);
                }
            } else {
                DocumentSymbol symbol = this.symbolMapper.toDocumentSymbol((EObject)casted);
                if (JSONHierarchicalSymbolService.isValid((DocumentSymbol)symbol)) {
                    acceptor.accept((DocumentSymbol)symbol);
                }
            }
        }
    }
}

