/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core.comm;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.comm.ISystemKeystoreProvider;
import org.osgi.framework.Bundle;

public class SystemKeystoreProviderManager {
    private static SystemKeystoreProviderManager _instance = new SystemKeystoreProviderManager();
    private List _extensions = new ArrayList();

    private SystemKeystoreProviderManager() {
    }

    public static SystemKeystoreProviderManager getInstance() {
        return _instance;
    }

    public void registerKeystoreProvider(ISystemKeystoreProvider ext) {
        this._extensions.add(ext);
    }

    public void registerKeystoreProvider(Bundle bundle, String className) {
        this._extensions.add(new ExtensionInfo(bundle, className));
    }

    public boolean hasProvider() {
        return !this._extensions.isEmpty();
    }

    public ISystemKeystoreProvider getProviderAt(int idx) {
        if (idx >= 0 && idx < this._extensions.size()) {
            Object o = this._extensions.get(idx);
            if (o instanceof ISystemKeystoreProvider) {
                return (ISystemKeystoreProvider)o;
            }
            if (o instanceof ExtensionInfo) {
                ExtensionInfo info = (ExtensionInfo)o;
                try {
                    Class keystoreProvider = info.bundle.loadClass(info.className);
                    ISystemKeystoreProvider extension = (ISystemKeystoreProvider)keystoreProvider.getConstructors()[0].newInstance(null);
                    this._extensions.set(idx, extension);
                    return extension;
                }
                catch (Exception e) {
                    RSECorePlugin.getDefault().getLog().log((IStatus)new Status(4, info.bundle.getSymbolicName(), -1, e.getMessage(), (Throwable)e));
                }
            }
        }
        return null;
    }

    public ISystemKeystoreProvider getDefaultProvider() {
        int idx = this._extensions.size() - 1;
        while (idx >= 0) {
            ISystemKeystoreProvider provider = this.getProviderAt(idx);
            if (provider != null) {
                return provider;
            }
            this._extensions.remove(idx);
            --idx;
        }
        return null;
    }

    public ISystemKeystoreProvider[] getProviders() {
        ArrayList<ISystemKeystoreProvider> providers = new ArrayList<ISystemKeystoreProvider>();
        int i = this._extensions.size() - 1;
        while (i >= 0) {
            ISystemKeystoreProvider provider = this.getProviderAt(i);
            if (provider != null) {
                providers.add(0, provider);
            } else {
                this._extensions.remove(i);
            }
            --i;
        }
        ISystemKeystoreProvider[] result = providers.toArray(new ISystemKeystoreProvider[providers.size()]);
        return result;
    }

    private static class ExtensionInfo {
        public Bundle bundle;
        public String className;

        public ExtensionInfo(Bundle bundle, String className) {
            this.bundle = bundle;
            this.className = className;
        }
    }
}

