/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.json.ide.contentassist;

import com.google.inject.Inject;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.json.JSON.JSONArray;
import org.eclipse.n4js.json.JSON.JSONObject;
import org.eclipse.n4js.json.JSON.JSONStringLiteral;
import org.eclipse.n4js.json.JSON.NameValuePair;
import org.eclipse.n4js.json.ide.contentassist.CompletionUtils;
import org.eclipse.n4js.json.services.JSONGrammarAccess;
import org.eclipse.n4js.packagejson.PackageJsonProperties;
import org.eclipse.n4js.packagejson.PackageJsonUtils;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.semver.Semver.VersionNumber;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IIdeContentProposalAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.IPrefixMatcher;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalProvider;

public class JSONIdeContentProposalProvider
extends IdeContentProposalProvider {
    @Inject
    private JSONGrammarAccess grammarAccess;
    @Inject
    private IPrefixMatcher prefixMatcher;
    @Inject
    private IN4JSCore n4jsCore;

    protected void _createProposals(Keyword keyword, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        if (keyword.getValue().length() < 4) {
            return;
        }
        super._createProposals(keyword, context, acceptor);
    }

    protected void _createProposals(Assignment assignment, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        List<String> namePath;
        AbstractElement terminal = assignment.getTerminal();
        if (terminal instanceof CrossReference) {
            this.createProposals(terminal, context, acceptor);
        }
        if (assignment == this.grammarAccess.getNameValuePairAccess().getNameAssignment_0()) {
            namePath = CompletionUtils.getJsonPathNames(context.getCurrentModel());
            this.proposeLocalPackages(context, acceptor, namePath);
        }
        if (assignment == this.grammarAccess.getNameValuePairAccess().getValueAssignment_2() && context.getCurrentModel() instanceof NameValuePair) {
            namePath = CompletionUtils.getJsonPathNames(context.getCurrentModel());
            this.proposeVersions(context, acceptor, namePath);
            this.proposeProjectTypes(context, acceptor, namePath);
        }
    }

    private void proposeLocalPackages(ContentAssistContext context, IIdeContentProposalAcceptor acceptor, List<String> namePath) {
        String last;
        if (!namePath.isEmpty() && (PackageJsonProperties.DEPENDENCIES.name.equals(last = namePath.get(namePath.size() - 1)) || PackageJsonProperties.DEV_DEPENDENCIES.name.equals(last))) {
            for (IN4JSProject project : this.n4jsCore.findAllProjects()) {
                N4JSProjectName projectName = project.getProjectName();
                ContentAssistEntry entryForModule = this.getProposalCreator().createProposal(String.valueOf('\"') + projectName.getRawName() + '\"', context, "MODULE", null);
                if (entryForModule == null) continue;
                acceptor.accept(entryForModule, this.getProposalPriorities().getDefaultPriority(entryForModule));
            }
        }
    }

    private void proposeProjectTypes(ContentAssistContext context, IIdeContentProposalAcceptor acceptor, List<String> namePath) {
        if (namePath.size() >= 2) {
            String n4js = namePath.get(namePath.size() - 2);
            String projectType = namePath.get(namePath.size() - 1);
            if (PackageJsonProperties.PROJECT_TYPE.name.equals(projectType) || PackageJsonProperties.N4JS.name.equals(n4js)) {
                ProjectType[] projectTypeArray = ProjectType.values();
                int n = projectTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ContentAssistEntry entryForProjectType;
                    ProjectType type = projectTypeArray[n2];
                    String asString = PackageJsonUtils.getProjectTypeStringRepresentation((ProjectType)type);
                    if (asString.equals(asString.toUpperCase())) {
                        asString = asString.toLowerCase();
                    }
                    if ((entryForProjectType = this.getProposalCreator().createProposal(String.valueOf('\"') + asString + '\"', context, "KEYWORD", null)) != null) {
                        acceptor.accept(entryForProjectType, this.getProposalPriorities().getDefaultPriority(entryForProjectType));
                    }
                    ++n2;
                }
            }
        }
    }

    private void proposeVersions(ContentAssistContext context, IIdeContentProposalAcceptor acceptor, List<String> namePath) {
        String devOrDep;
        if (namePath.size() >= 2 && (PackageJsonProperties.DEPENDENCIES.name.equals(devOrDep = namePath.get(namePath.size() - 2)) || PackageJsonProperties.DEV_DEPENDENCIES.name.equals(devOrDep))) {
            NameValuePair pair = (NameValuePair)context.getCurrentModel();
            IN4JSProject project = (IN4JSProject)this.n4jsCore.findProject(new N4JSProjectName(pair.getName())).orNull();
            if (project != null) {
                VersionNumber version = project.getVersion();
                ContentAssistEntry versionEntry = this.getProposalCreator().createProposal(String.valueOf('\"') + version.toString() + '\"', context, "VALUE", null);
                acceptor.accept(versionEntry, this.getProposalPriorities().getDefaultPriority(versionEntry));
            }
            ContentAssistEntry wildcard = this.getProposalCreator().createProposal("\"*\"", context, "VALUE", null);
            acceptor.accept(wildcard, this.getProposalPriorities().getDefaultPriority(wildcard));
        }
    }

    protected void _createProposals(RuleCall ruleCall, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        if (this.grammarAccess.getNameValuePairRule() == ruleCall.getRule()) {
            this.createNameValueProposals(context, acceptor);
        }
    }

    private void createNameValueProposals(ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        EObject model = context.getCurrentModel();
        List<String> namePath = CompletionUtils.getJsonPathNames(model);
        Set<String> alreadyUsedNames = CompletionUtils.getAlreadyUsedNames(model);
        List pathProps = PackageJsonProperties.valuesOfPath(namePath);
        for (PackageJsonProperties pathProp : pathProps) {
            String name;
            String label = name = pathProp.name;
            if (alreadyUsedNames.contains(name) || !this.isMatchingPairPrefix(context, name)) continue;
            if (context.getPrefix().startsWith("\"")) {
                label = String.valueOf('\"') + name + '\"';
            }
            String proposal = null;
            String kind = null;
            if (pathProp.valueType == JSONStringLiteral.class) {
                proposal = String.format("\"%s\": \"$1\"$0", name);
                kind = "PROPERTY";
            } else if (pathProp.valueType == JSONArray.class) {
                proposal = String.format("\"%s\": [\n\t$1\n]$0", name);
                kind = "VALUE";
            } else if (pathProp.valueType == JSONObject.class) {
                proposal = String.format("\"%s\": {\n\t$1\n}$0", name);
                kind = "CLASS";
            }
            if (proposal == null) continue;
            this.addTemplateProposal(proposal, label, pathProp.description, kind, context, acceptor);
        }
        if (pathProps.isEmpty()) {
            this.addTemplateProposal("\"${1:name}\": \"$2\"$0", "<value>", "Generic name value pair", "PROPERTY", context, acceptor);
            this.addTemplateProposal("\"${1:name}\": [\n\t$2\n]$0", "<array>", "Generic name array pair", "VALUE", context, acceptor);
            this.addTemplateProposal("\"${1:name}\": {\n\t$2\n}$0", "<object>", "Generic name object pair", "CLASS", context, acceptor);
        }
    }

    private void addTemplateProposal(String proposal, String label, String description, String kind, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        if (this.getProposalCreator().isValidProposal(label, context.getPrefix(), context)) {
            ContentAssistEntry entry = new ContentAssistEntry();
            entry.setProposal(proposal);
            entry.setPrefix(context.getPrefix());
            entry.setKind("SNIPPET:" + kind);
            entry.setLabel(label);
            entry.setDescription(description);
            acceptor.accept(entry, this.getProposalPriorities().getDefaultPriority(entry));
        }
    }

    private boolean isMatchingPairPrefix(ContentAssistContext context, String name) {
        return this.prefixMatcher.isCandidateMatchingPrefix(name, context.getPrefix()) || this.prefixMatcher.isCandidateMatchingPrefix("\"" + name, context.getPrefix());
    }
}

