/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.n4JS;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.n4JS.ArrowFunction;
import org.eclipse.n4js.n4JS.AssignmentExpression;
import org.eclipse.n4js.n4JS.BindingElement;
import org.eclipse.n4js.n4JS.BindingPattern;
import org.eclipse.n4js.n4JS.BindingProperty;
import org.eclipse.n4js.n4JS.DestructNode;
import org.eclipse.n4js.n4JS.DestructureUtils;
import org.eclipse.n4js.n4JS.ExportedVariableDeclaration;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ExpressionStatement;
import org.eclipse.n4js.n4JS.ForStatement;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.FunctionOrFieldAccessor;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.n4JS.ParenExpression;
import org.eclipse.n4js.n4JS.PropertyAssignment;
import org.eclipse.n4js.n4JS.ScriptElement;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.StringLiteral;
import org.eclipse.n4js.n4JS.ThisArgProvider;
import org.eclipse.n4js.n4JS.ThisLiteral;
import org.eclipse.n4js.n4JS.ThisTarget;
import org.eclipse.n4js.n4JS.TypeDefiningElement;
import org.eclipse.n4js.n4JS.VariableBinding;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.VariableDeclarationContainer;
import org.eclipse.n4js.n4JS.VariableEnvironmentElement;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.SyntaxRelatedTElement;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TStructMember;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;

public abstract class N4JSASTUtils {
    private static final int SEED = 9415;
    public static final String CONSTRUCTOR = "constructor";

    public static boolean isWriteAccess(EObject reference) {
        EObject parent = reference.eContainer();
        while (parent instanceof ParameterizedPropertyAccessExpression && ((ParameterizedPropertyAccessExpression)parent).getTarget() == reference) {
            reference = parent;
            parent = parent.eContainer();
        }
        if (parent == null) {
            return false;
        }
        if (parent instanceof AssignmentExpression) {
            AssignmentExpression ae = (AssignmentExpression)parent;
            return ae.getLhs() == reference;
        }
        if (parent instanceof ForStatement) {
            ForStatement fs = (ForStatement)parent;
            return fs.getInitExpr() == reference;
        }
        DestructNode dNode = DestructureUtils.getCorrespondingDestructNode(reference);
        if (dNode != null) {
            return (dNode = dNode.findNodeForElement(parent)) != null;
        }
        return false;
    }

    public static VariableEnvironmentElement getScope(IdentifiableElement elemInAST) {
        return N4JSASTUtils.getScope((EObject)elemInAST, N4JSASTUtils.isBlockScoped(elemInAST));
    }

    public static VariableEnvironmentElement getScope(EObject astNode, boolean isBlockScoped) {
        VariableEnvironmentElement scope = (VariableEnvironmentElement)EcoreUtil2.getContainerOfType((EObject)astNode, VariableEnvironmentElement.class);
        if (!isBlockScoped) {
            while (scope != null && scope.appliesOnlyToBlockScopedElements()) {
                scope = (VariableEnvironmentElement)EcoreUtil2.getContainerOfType((EObject)scope.eContainer(), VariableEnvironmentElement.class);
            }
        }
        return scope;
    }

    public static boolean isTopLevelCode(EObject astNode) {
        return EcoreUtil2.getContainerOfType((EObject)astNode.eContainer(), FunctionOrFieldAccessor.class) == null;
    }

    public static boolean isBlockScoped(IdentifiableElement elemInAST) {
        VariableDeclarationContainer parent;
        if (elemInAST instanceof VariableDeclaration && (parent = N4JSASTUtils.getVariableDeclarationContainer((VariableDeclaration)elemInAST)) != null) {
            return parent.isBlockScoped();
        }
        return false;
    }

    public static boolean isBodyOfFunctionOrFieldAccessor(EObject astNode) {
        EObject parent;
        if (astNode != null && (parent = astNode.eContainer()) instanceof FunctionOrFieldAccessor) {
            return astNode == ((FunctionOrFieldAccessor)parent).getBody();
        }
        return false;
    }

    public static VariableDeclarationContainer getVariableDeclarationContainer(VariableDeclaration varDecl) {
        EObject destructRoot;
        EObject parent = varDecl.eContainer();
        if ((parent instanceof BindingProperty || parent instanceof BindingElement) && (destructRoot = DestructureUtils.getRoot(varDecl)) instanceof BindingPattern && destructRoot.eContainer() instanceof VariableBinding) {
            parent = destructRoot.eContainer().eContainer();
        }
        if (parent instanceof VariableDeclarationContainer) {
            return (VariableDeclarationContainer)parent;
        }
        return null;
    }

    public static ThisTarget getProbableThisTarget(EObject location) {
        ThisArgProvider indirectThisArgProvider;
        N4MethodDeclaration thisArgProvider;
        if (location == null || location.eContainer() == null) {
            return null;
        }
        ThisArgProvider thisArgProvider2 = thisArgProvider = location instanceof N4MethodDeclaration ? (N4MethodDeclaration)location : (ThisArgProvider)EcoreUtil2.getContainerOfType((EObject)location.eContainer(), ThisArgProvider.class);
        if (thisArgProvider == null) {
            return null;
        }
        ThisTarget thisTarget = (ThisTarget)EcoreUtil2.getContainerOfType((EObject)thisArgProvider.eContainer(), ThisTarget.class);
        if (thisTarget != null && (indirectThisArgProvider = (ThisArgProvider)EcoreUtil2.getContainerOfType((EObject)thisArgProvider.eContainer(), ThisArgProvider.class)) != null && EcoreUtil.isAncestor((EObject)thisTarget, (EObject)indirectThisArgProvider)) {
            return null;
        }
        return thisTarget;
    }

    public static Expression getContainingExpression(EObject eobj) {
        if (eobj == null || eobj.eContainer() == null) {
            return null;
        }
        return (Expression)EcoreUtil2.getContainerOfType((EObject)eobj.eContainer(), Expression.class);
    }

    public static Statement getContainingStatement(EObject eobj) {
        if (eobj == null || eobj.eContainer() == null) {
            return null;
        }
        return (Statement)EcoreUtil2.getContainerOfType((EObject)eobj.eContainer(), Statement.class);
    }

    public static FunctionDefinition getContainingFunction(EObject eobj) {
        if (eobj == null || eobj.eContainer() == null) {
            return null;
        }
        return (FunctionDefinition)EcoreUtil2.getContainerOfType((EObject)eobj.eContainer(), FunctionDefinition.class);
    }

    public static FunctionOrFieldAccessor getContainingFunctionOrAccessor(EObject eobj) {
        if (eobj == null || eobj.eContainer() == null) {
            return null;
        }
        return (FunctionOrFieldAccessor)EcoreUtil2.getContainerOfType((EObject)eobj.eContainer(), FunctionOrFieldAccessor.class);
    }

    public static ArrowFunction getContainingSingleExpressionArrowFunction(Expression expression) {
        ArrowFunction arrFun;
        EObject grandgrandparent;
        EObject parent = expression.eContainer();
        EObject grandparent = parent != null ? parent.eContainer() : null;
        EObject eObject = grandgrandparent = grandparent != null ? grandparent.eContainer() : null;
        if (grandgrandparent instanceof ArrowFunction && (arrFun = (ArrowFunction)grandgrandparent).isSingleExprImplicitReturn() && arrFun.implicitReturnExpr() == expression) {
            return arrFun;
        }
        return null;
    }

    public static boolean isSemiLegalAssignmentToFinalFieldInCtor(EObject expr, TMember writtenMember) {
        TClass containingTClass;
        boolean simpleCompare;
        if (!(expr instanceof AssignmentExpression)) {
            return false;
        }
        AssignmentExpression assExpr = (AssignmentExpression)expr;
        Expression lhs = assExpr.getLhs();
        if (!(lhs instanceof ParameterizedPropertyAccessExpression)) {
            return false;
        }
        ParameterizedPropertyAccessExpression paExpr = (ParameterizedPropertyAccessExpression)lhs;
        if (!(paExpr.getTarget() instanceof ThisLiteral)) {
            return false;
        }
        if (paExpr.getProperty() != null && !paExpr.getProperty().eIsProxy()) {
            if (writtenMember != null) {
                if (paExpr.getProperty() != writtenMember) {
                    return false;
                }
            } else if (paExpr.getProperty() instanceof TMember) {
                writtenMember = (TMember)paExpr.getProperty();
            }
        }
        if (!(writtenMember instanceof TField)) {
            return false;
        }
        TField field = (TField)writtenMember;
        if (!field.isFinal()) {
            return false;
        }
        FunctionDefinition containingFunction = N4JSASTUtils.getContainingFunction(assExpr);
        if (containingFunction == null) {
            return false;
        }
        Type containingTFunction = containingFunction.getDefinedType();
        if (containingTFunction == null) {
            return false;
        }
        ContainerType ownerOfField = field.getContainingType();
        if (ownerOfField == null) {
            return false;
        }
        TMember ctorOfOwner = N4JSASTUtils.getOwnOrSuperCtor(ownerOfField);
        if (ctorOfOwner == null) {
            return false;
        }
        boolean bl = simpleCompare = containingTFunction == ctorOfOwner;
        if (simpleCompare) {
            return true;
        }
        if (containingTFunction.eContainer() instanceof TClass && (containingTClass = (TClass)containingTFunction.eContainer()).isStaticPolyfill() && containingTClass.getSuperClassRef() != null && containingTClass.getSuperClassRef().getDeclaredType() instanceof TClass) {
            TClass filledClass = (TClass)containingTClass.getSuperClassRef().getDeclaredType();
            TMember replacedCtorOfFilledClass = N4JSASTUtils.getOwnOrSuperCtor(filledClass);
            return replacedCtorOfFilledClass == ctorOfOwner;
        }
        return false;
    }

    private static TMember getOwnOrSuperCtor(ContainerType<?> ownerOfField) {
        Object klass = (TClass)(ownerOfField instanceof TClass ? ownerOfField : null);
        while (klass != null) {
            Type declaredType;
            TMember ctor = klass.findOwnedMember(CONSTRUCTOR);
            if (ctor != null) {
                return ctor;
            }
            ParameterizedTypeRef superClassRef = klass.getSuperClassRef();
            klass = superClassRef == null ? null : (TClass)((declaredType = superClassRef.getDeclaredType()) instanceof TClass ? declaredType : null);
        }
        return null;
    }

    public static EObject getCorrespondingTypeModelElement(EObject obj) {
        if (obj != null && obj.eClass().getEPackage() == TypesPackage.eINSTANCE) {
            if (obj instanceof TStructMember && ((TStructMember)obj).getDefinedMember() != null) {
                return ((TStructMember)obj).getDefinedMember();
            }
            return obj;
        }
        if (obj instanceof TypeDefiningElement) {
            return ((TypeDefiningElement)obj).getDefinedType();
        }
        if (obj instanceof N4MemberDeclaration) {
            return ((N4MemberDeclaration)obj).getDefinedTypeElement();
        }
        if (obj instanceof PropertyAssignment) {
            return ((PropertyAssignment)obj).getDefinedMember();
        }
        if (obj instanceof FormalParameter) {
            return ((FormalParameter)obj).getDefinedTypeElement();
        }
        if (obj instanceof ExportedVariableDeclaration) {
            return ((ExportedVariableDeclaration)obj).getDefinedVariable();
        }
        return null;
    }

    public static EObject getCorrespondingASTNode(EObject obj) {
        if (obj != null && obj.eClass().getEPackage() == N4JSPackage.eINSTANCE) {
            return obj;
        }
        if (obj instanceof SyntaxRelatedTElement) {
            return ((SyntaxRelatedTElement)obj).getAstElement();
        }
        return null;
    }

    public static boolean isStringLiteralExpression(ScriptElement element) {
        Expression expression;
        return element instanceof ExpressionStatement && (expression = ((ExpressionStatement)element).getExpression()) instanceof StringLiteral;
    }

    public static EObject skipParenExpressionUpward(EObject astNode) {
        while (astNode instanceof ParenExpression) {
            astNode = astNode.eContainer();
        }
        return astNode;
    }

    public static TypableElement skipParenExpressionDownward(TypableElement astNode) {
        while (astNode instanceof ParenExpression) {
            Expression expr = ((ParenExpression)astNode).getExpression();
            if (expr == null) break;
            astNode = expr;
        }
        return astNode;
    }

    public static String md5Hex(XtextResource resource) {
        String source;
        IParseResult parseResult = resource.getParseResult();
        ICompositeNode rootNode = parseResult != null ? parseResult.getRootNode() : null;
        String string = source = rootNode != null ? rootNode.getText() : null;
        if (source == null) {
            throw new IllegalStateException("resource does not have a valid parse result: " + resource.getURI());
        }
        return Hashing.murmur3_128((int)9415).hashString((CharSequence)source, Charsets.UTF_8).toString();
    }
}

