/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.outline;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.n4js.ui.outline.N4JSEObjectNode;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.EObjectNode;
import org.eclipse.xtext.ui.editor.outline.impl.OutlineFilterAndSorter;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;

public class MetaTypeAwareComparator
implements OutlineFilterAndSorter.IComparator {
    @Inject
    private IPreferenceStoreAccess preferenceStoreAccess;
    static final Map<Integer, Integer> METATYPESORTORDER;

    static {
        int[][] tto;
        METATYPESORTORDER = new HashMap<Integer, Integer>();
        int[][] nArrayArray = tto = new int[][]{{1, 1}, {56, 2}, {15, 3}, {52, 4}, {37, 5}, {36, 6}, {45, 7}, {48, 7}, {50, 7}, {41, 8}};
        int n = tto.length;
        int n2 = 0;
        while (n2 < n) {
            int[] typeToOrder = nArrayArray[n2];
            METATYPESORTORDER.put(typeToOrder[0], typeToOrder[1]);
            ++n2;
        }
    }

    public int compare(IOutlineNode o1, IOutlineNode o2) {
        int category2;
        int category1 = this.getCategory(o1);
        if (category1 != (category2 = this.getCategory(o2))) {
            return category1 - category2;
        }
        return o1.getText().toString().compareTo(o2.getText().toString());
    }

    public boolean isEnabled() {
        return this.preferenceStoreAccess.getPreferenceStore().getBoolean("ui.outline.sort2");
    }

    private int getCategory(IOutlineNode node) {
        if (node instanceof EObjectNode) {
            EClass eclass = ((EObjectNode)node).getEClass();
            int id = eclass.getClassifierID();
            int key = 10000 + id;
            Integer sortKey = METATYPESORTORDER.get(id);
            if (sortKey != null) {
                key = sortKey * 1000;
            }
            if (node instanceof N4JSEObjectNode) {
                N4JSEObjectNode n4node = (N4JSEObjectNode)node;
                if (!n4node.isStatic) {
                    key += 100;
                }
                if (n4node.isConstructor) {
                    key -= 50;
                }
            }
            return key;
        }
        return -1;
    }
}

