/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.registry;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.xpect.registry.AbstractLanguageInfo;
import org.eclipse.xpect.registry.EPackageRegistrar;
import org.eclipse.xpect.registry.FileExtensionRegistrar;
import org.eclipse.xpect.registry.IEPackageInfo;
import org.eclipse.xpect.registry.IEmfFileExtensionInfo;
import org.eclipse.xpect.registry.ILanguageInfo;
import org.eclipse.xpect.services.XtResourceServiceProviderProvider;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.util.Modules2;

public class StandaloneLanguageRegistry
implements ILanguageInfo.Registry {
    private static final Logger LOG = Logger.getLogger(StandaloneLanguageRegistry.class);
    private static boolean running = false;
    private Map<String, ILanguageInfo> ext2language;
    private Map<String, ILanguageInfo> name2language;

    public StandaloneLanguageRegistry() {
        try {
            this.init();
        }
        catch (Throwable e) {
            LOG.error((Object)"Error initalizing language registry", e);
        }
    }

    @Override
    public ILanguageInfo getLanguageByFileExtension(String fileExtension) {
        return this.ext2language.get(fileExtension);
    }

    @Override
    public ILanguageInfo getLanguageByName(String name) {
        return this.name2language.get(name);
    }

    @Override
    public Collection<ILanguageInfo> getLanguages() {
        return this.name2language.values();
    }

    protected void init() {
        this.ext2language = Maps.newHashMap();
        this.name2language = Maps.newHashMap();
        if (EcorePlugin.IS_ECLIPSE_RUNNING) {
            throw new IllegalStateException("This class can only run in standalone mode (no OSGi, no Eclipse)");
        }
        if (running) {
            throw new IllegalStateException("I want to be a singleton!");
        }
        running = true;
        for (String nsURI : IEPackageInfo.Registry.INSTANCE.getNamespaceURIs()) {
            EPackageRegistrar.register(IEPackageInfo.Registry.INSTANCE.getEPackageInfo(nsURI));
        }
        for (IEmfFileExtensionInfo info : IEmfFileExtensionInfo.Registry.INSTANCE.getFileExtensionInfos()) {
            FileExtensionRegistrar.register(info);
            if (!(info instanceof IEmfFileExtensionInfo.IXtextFileExtensionInfo)) continue;
            StandaloneLanguageInfoImpl infoImpl = new StandaloneLanguageInfoImpl((IEmfFileExtensionInfo.IXtextFileExtensionInfo)info);
            this.name2language.put(infoImpl.getLanguageName(), infoImpl);
            for (String ext : info.getFileExtensions()) {
                this.ext2language.put(ext, infoImpl);
            }
        }
        this.registerRSPProviderForXt();
    }

    protected void registerRSPProviderForXt() {
        if (IResourceServiceProvider.Registry.INSTANCE.getExtensionToFactoryMap().get("xt") == null) {
            IResourceServiceProvider.Registry.INSTANCE.getExtensionToFactoryMap().put("xt", XtResourceServiceProviderProvider.INSTANCE);
        }
    }

    protected static class StandaloneLanguageInfoImpl
    extends AbstractLanguageInfo {
        public StandaloneLanguageInfoImpl(IEmfFileExtensionInfo.IXtextFileExtensionInfo info) {
            super(info);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        protected Injector createInjector(Module ... modules) {
            try {
                if (modules.length > 0) {
                    return Guice.createInjector((Module[])new Module[]{Modules2.mixin((Module[])new Module[]{this.getRuntimeModule(), Modules2.mixin((Module[])modules)})});
                }
                return Guice.createInjector((Module[])new Module[]{this.getRuntimeModule()});
            }
            catch (Throwable t) {
                moduleNames = Lists.newArrayList((Object[])new String[]{this.getRuntimeModule().getClass().getName()});
                var7_4 = modules;
                var6_5 = modules.length;
                var5_6 = 0;
                ** while (var5_6 < var6_5)
            }
lbl-1000:
            // 1 sources

            {
                m = var7_4[var5_6];
                moduleNames.add(m.getClass().getName());
                ++var5_6;
                continue;
            }
lbl16:
            // 1 sources

            throw new RuntimeException("Error creating Injector with modules " + Joiner.on((String)", ").join((Iterable)moduleNames), t);
        }
    }
}

