/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.internal;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.external.ExternalProject;
import org.eclipse.n4js.external.N4JSExternalProject;
import org.eclipse.n4js.internal.FileBasedExternalPackageManager;
import org.eclipse.n4js.internal.N4JSBrokenProjectException;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.projectModel.locations.SafeURI;
import org.eclipse.n4js.ui.internal.N4JSEclipseModel;
import org.eclipse.n4js.ui.internal.N4JSEclipseProject;
import org.eclipse.n4js.utils.URIUtils;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

@Singleton
public class ExternalProjectLoader {
    private static final Logger LOGGER = Logger.getLogger(ExternalProjectLoader.class);
    @Inject
    private N4JSEclipseModel model;
    @Inject
    private FileBasedExternalPackageManager packageManager;

    public Pair<N4JSExternalProject, ProjectDescription> load(FileURI rootLocation) {
        try {
            ProjectDescription projectDescription = this.packageManager.loadProjectDescriptionFromProjectRoot(rootLocation);
            if (projectDescription != null) {
                File projectRoot = URIUtils.toFile((URI)rootLocation.toURI());
                ExternalProject p = new ExternalProject(projectRoot, "org.eclipse.xtext.ui.shared.xtextNature", "org.eclipse.xtext.ui.shared.xtextBuilder");
                N4JSEclipseProject pp = new N4JSEclipseProject((IProject)p, (SafeURI<?>)rootLocation, this.model);
                N4JSExternalProject ppp = new N4JSExternalProject(projectRoot, (IN4JSProject)pp);
                return Tuples.create((Object)ppp, (Object)projectDescription);
            }
        }
        catch (N4JSBrokenProjectException e) {
            LOGGER.error((Object)"Failed to obtain project description for external library.");
        }
        return null;
    }
}

