/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.contentassist;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.antlr.runtime.BaseRecognizer;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RecognizerSharedState;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.ide.contentassist.antlr.N4JSParser;
import org.eclipse.n4js.ide.contentassist.antlr.internal.InternalN4JSParser;
import org.eclipse.n4js.services.N4JSGrammarAccess;
import org.eclipse.n4js.ui.contentassist.ContentAssistTokenTypeMapper;
import org.eclipse.n4js.ui.contentassist.TokenSourceFactory;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.UnorderedGroup;
import org.eclipse.xtext.ide.editor.contentassist.antlr.FollowElement;
import org.eclipse.xtext.ide.editor.contentassist.antlr.LookAheadTerminal;
import org.eclipse.xtext.ide.editor.contentassist.antlr.ObservableXtextTokenStream;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.AbstractInternalContentAssistParser;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.InfiniteRecursion;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parser.antlr.ITokenDefProvider;
import org.eclipse.xtext.parser.antlr.IUnorderedGroupHelper;
import org.eclipse.xtext.xbase.lib.util.ReflectExtensions;

public class CustomN4JSParser
extends N4JSParser {
    @Inject
    private TokenSourceFactory tokenSourceFactory;
    private BitSet mandatoryASI;
    private int eol;
    private int semi;
    private Group postfixGroup;
    @Inject
    private final ReflectExtensions reflector = new ReflectExtensions();

    protected CustomInternalN4JSParser createParser() {
        CustomInternalN4JSParser result = new CustomInternalN4JSParser();
        result.setGrammarAccess(this.getGrammarAccess());
        return result;
    }

    protected Collection<FollowElement> getFollowElements(AbstractInternalContentAssistParser parser) {
        try {
            InternalN4JSParser casted = (InternalN4JSParser)parser;
            casted.entryRuleScript();
            return casted.getFollowElements();
        }
        catch (RecognitionException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<FollowElement> getFollowElements(INode node, int startOffset, int endOffset, boolean strict) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        TokenSource tokenSource = this.tokenSourceFactory.toTokenSource(node, startOffset, endOffset);
        CustomInternalN4JSParser parser = this.collectFollowElements(tokenSource, strict, result);
        this.adjustASIAndCollectFollowElements(parser, strict, result);
        return Lists.newArrayList((Iterable)result);
    }

    private void adjustASIAndCollectFollowElements(CustomInternalN4JSParser previousParser, boolean strict, Set<FollowElement> result) {
        ObservableXtextTokenStream tokens = (ObservableXtextTokenStream)previousParser.getTokenStream();
        int lastTokenIndex = tokens.size() - 1;
        if (lastTokenIndex >= 0) {
            CommonToken lastToken = (CommonToken)tokens.LT(-1);
            List tokenList = tokens.getTokens();
            if (lastToken == null) {
                return;
            }
            if (this.shouldSkipASI(lastToken)) {
                if (this.maySkipASI(lastToken, tokens)) {
                    tokenList.remove(lastTokenIndex);
                    result.addAll(this.resetAndGetFollowElements(tokens, strict));
                    this.removePostfixOperator(result);
                }
            } else if (this.shouldAddSyntheticSemicolon(previousParser, lastTokenIndex, lastToken)) {
                CommonToken token = new CommonToken(this.semi);
                tokenList.add(token);
                result.addAll(this.resetAndGetFollowElements(tokens, strict));
                this.removePostfixOperator(result);
            }
        }
    }

    private void removePostfixOperator(Set<FollowElement> result) {
        Iterator<FollowElement> iter = result.iterator();
        while (iter.hasNext()) {
            FollowElement fe = iter.next();
            if (this.postfixGroup != fe.getGrammarElement()) continue;
            iter.remove();
        }
    }

    private boolean maySkipASI(CommonToken lastToken, ObservableXtextTokenStream tokens) {
        int countDownFrom = lastToken.getTokenIndex();
        int i = countDownFrom - 1;
        while (i >= 0) {
            Token prevToken = tokens.get(i);
            if (prevToken.getChannel() == 0) {
                return !this.mandatoryASI.get(prevToken.getType());
            }
            --i;
        }
        return true;
    }

    private boolean shouldSkipASI(CommonToken lastToken) {
        if (lastToken.getType() == this.eol) {
            return true;
        }
        return lastToken.getType() == this.semi && lastToken.getText() != null && !";".equals(lastToken.getText());
    }

    private boolean shouldAddSyntheticSemicolon(CustomInternalN4JSParser previousParser, int lastTokenIndex, CommonToken lastNonHiddenToken) {
        return lastTokenIndex != lastNonHiddenToken.getTokenIndex() && previousParser.getState().lastErrorIndex != lastNonHiddenToken.getTokenIndex();
    }

    private Collection<FollowElement> resetAndGetFollowElements(ObservableXtextTokenStream tokens, boolean strict) {
        CustomInternalN4JSParser parser = this.createParser();
        parser.setStrict(strict);
        tokens.reset();
        return this.doGetFollowElements((AbstractInternalContentAssistParser)parser, tokens);
    }

    private CustomInternalN4JSParser collectFollowElements(TokenSource tokens, boolean strict, Set<FollowElement> result) {
        CustomInternalN4JSParser parser = this.createParser();
        parser.setStrict(strict);
        try {
            ObservableXtextTokenStream tokenStream = new ObservableXtextTokenStream(tokens, (ITokenDefProvider)parser);
            result.addAll(this.doGetFollowElements((AbstractInternalContentAssistParser)parser, tokenStream));
        }
        catch (InfiniteRecursion infinite) {
            result.addAll(parser.getFollowElements());
        }
        return parser;
    }

    private Collection<FollowElement> doGetFollowElements(AbstractInternalContentAssistParser parser, ObservableXtextTokenStream tokens) {
        tokens.setInitialHiddenTokens(this.getInitialHiddenTokens());
        parser.setTokenStream((TokenStream)tokens);
        IUnorderedGroupHelper helper = (IUnorderedGroupHelper)this.getUnorderedGroupHelper().get();
        parser.setUnorderedGroupHelper(helper);
        helper.initializeWith((BaseRecognizer)parser);
        tokens.setListener((ObservableXtextTokenStream.StreamListener)parser);
        Collection<FollowElement> followElements = this.getFollowElements(parser);
        return followElements;
    }

    public Collection<FollowElement> getFollowElements(String input, boolean strict) {
        throw new UnsupportedOperationException("Use getFollowElements(INode, int, int, boolean) instead");
    }

    public void setTokenSourceFactory(TokenSourceFactory tokenSourceFactory) {
        this.tokenSourceFactory = tokenSourceFactory;
    }

    public TokenSourceFactory getTokenSourceFactory() {
        return this.tokenSourceFactory;
    }

    @Inject
    public void initializeTokenTypes(ContentAssistTokenTypeMapper mapper, N4JSGrammarAccess grammarAccess) {
        BitSet bits = new BitSet();
        bits.set(mapper.getInternalTokenType((EObject)grammarAccess.getReturnStatementAccess().getReturnKeyword_1()));
        bits.set(mapper.getInternalTokenType((EObject)grammarAccess.getThrowStatementAccess().getThrowKeyword_0()));
        bits.set(mapper.getInternalTokenType((EObject)grammarAccess.getBreakStatementAccess().getBreakKeyword_1()));
        bits.set(mapper.getInternalTokenType((EObject)grammarAccess.getContinueStatementAccess().getContinueKeyword_1()));
        this.mandatoryASI = bits;
        this.eol = mapper.getInternalTokenType((EObject)this.getGrammarAccess().getEOLRule());
        this.semi = mapper.getInternalTokenType((EObject)this.getGrammarAccess().getSemiAccess().getSemicolonKeyword());
        this.postfixGroup = grammarAccess.getPostfixExpressionAccess().getGroup_1();
    }

    private <T> T reflective(String methodName, Object ... args) {
        try {
            return (T)this.reflector.invoke((Object)this, methodName, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<FollowElement> getFollowElements(FollowElement element) {
        if (element.getLookAhead() <= 1) {
            throw new IllegalArgumentException("lookahead may not be less than or equal to 1");
        }
        ArrayList<FollowElement> result = new ArrayList<FollowElement>();
        Collection elementsToParse = (Collection)this.reflective("getElementsToParse", element);
        for (AbstractElement elementToParse : elementsToParse) {
            String[][] allRuleNames;
            elementToParse = this.unwrapSingleElementGroups(elementToParse);
            String ruleName = this.getRuleName(elementToParse);
            String[][] stringArray = allRuleNames = (String[][])this.reflective("getRequiredRuleNames", ruleName, element.getParamStack(), elementToParse);
            int n = allRuleNames.length;
            int n2 = 0;
            while (n2 < n) {
                String[] ruleNames = stringArray[n2];
                int i = 0;
                while (i < ruleNames.length) {
                    CustomInternalN4JSParser parser = this.createParser();
                    parser.setUnorderedGroupHelper((IUnorderedGroupHelper)this.getUnorderedGroupHelper().get());
                    parser.getUnorderedGroupHelper().initializeWith((BaseRecognizer)parser);
                    final Iterator iter = element.getLookAheadTerminals().iterator();
                    ObservableXtextTokenStream tokens = new ObservableXtextTokenStream(new TokenSource(){

                        public Token nextToken() {
                            if (iter.hasNext()) {
                                LookAheadTerminal lookAhead = (LookAheadTerminal)iter.next();
                                return lookAhead.getToken();
                            }
                            return Token.EOF_TOKEN;
                        }

                        public String getSourceName() {
                            return "LookAheadTerminalTokenSource";
                        }
                    }, (ITokenDefProvider)parser);
                    parser.setTokenStream((TokenStream)tokens);
                    tokens.setListener((ObservableXtextTokenStream.StreamListener)parser);
                    parser.getGrammarElements().addAll(element.getTrace());
                    parser.getGrammarElements().add(elementToParse);
                    parser.getLocalTrace().addAll(element.getLocalTrace());
                    parser.getLocalTrace().add(elementToParse);
                    parser.getParamStack().addAll(element.getParamStack());
                    if (elementToParse instanceof UnorderedGroup && element.getGrammarElement() == elementToParse) {
                        UnorderedGroup group = (UnorderedGroup)elementToParse;
                        final IUnorderedGroupHelper helper = parser.getUnorderedGroupHelper();
                        helper.enter(group);
                        for (AbstractElement consumed : element.getHandledUnorderedGroupElements()) {
                            parser.before((EObject)consumed);
                            helper.select(group, group.getElements().indexOf((Object)consumed));
                            helper.returnFromSelection(group);
                            parser.after((EObject)consumed);
                        }
                        parser.setUnorderedGroupHelper(new IUnorderedGroupHelper(){
                            boolean first = true;

                            public void initializeWith(BaseRecognizer recognizer) {
                                helper.initializeWith(recognizer);
                            }

                            public void enter(UnorderedGroup group) {
                                if (!this.first) {
                                    helper.enter(group);
                                }
                                this.first = false;
                            }

                            public void leave(UnorderedGroup group) {
                                helper.leave(group);
                            }

                            public boolean canSelect(UnorderedGroup group, int index) {
                                return helper.canSelect(group, index);
                            }

                            public void select(UnorderedGroup group, int index) {
                                helper.select(group, index);
                            }

                            public void returnFromSelection(UnorderedGroup group) {
                                helper.returnFromSelection(group);
                            }

                            public boolean canLeave(UnorderedGroup group) {
                                return helper.canLeave(group);
                            }

                            public IUnorderedGroupHelper.UnorderedGroupState snapShot(UnorderedGroup ... groups) {
                                return helper.snapShot(groups);
                            }
                        });
                    }
                    Collection elements = (Collection)this.reflective("getFollowElements", new Object[]{parser, elementToParse, ruleNames, i});
                    result.addAll(elements);
                    ++i;
                }
                ++n2;
            }
        }
        return result;
    }

    protected static class CustomInternalN4JSParser
    extends InternalN4JSParser {
        public CustomInternalN4JSParser() {
            super(null);
        }

        public RecognizerSharedState getState() {
            return this.state;
        }
    }
}

