/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.organize.imports;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.n4JS.DefaultImportSpecifier;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.ImportSpecifier;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.n4JS.NamespaceImportSpecifier;
import org.eclipse.n4js.ui.organize.imports.ImportsSorter;
import org.eclipse.n4js.ui.utils.ImportSpacerUserPreferenceHelper;
import org.eclipse.n4js.utils.UtilN4;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ImportDeclarationTextHelper {
    @Inject
    private ImportSpacerUserPreferenceHelper spacerPreference;

    public String extractPureText(ImportDeclaration declaration, XtextResource resource, Adapter nodelessMarker) {
        String spacer = this.spacerPreference.getSpacingPreference((Resource)resource);
        boolean _contains = declaration.eAdapters().contains((Object)nodelessMarker);
        if (_contains) {
            boolean _tripleEquals;
            EList _importSpecifiers = declaration.getImportSpecifiers();
            ArrayList<ImportSpecifier> impSpec = new ArrayList<ImportSpecifier>((Collection<ImportSpecifier>)_importSpecifiers);
            String module = declaration.getModule().getModuleSpecifier();
            int _size = impSpec.size();
            boolean bl = _tripleEquals = _size == 1;
            if (_tripleEquals) {
                ImportSpecifier onlyImpSpec = (ImportSpecifier)impSpec.get(0);
                if (onlyImpSpec instanceof NamespaceImportSpecifier) {
                    return this.namespacePureText((NamespaceImportSpecifier)onlyImpSpec, module);
                }
                NamedImportSpecifier namedSpec = (NamedImportSpecifier)onlyImpSpec;
                if (namedSpec instanceof DefaultImportSpecifier) {
                    return this.defaultPureText((DefaultImportSpecifier)namedSpec, module);
                }
                return this.namedPureText(namedSpec, module, spacer);
            }
            return this.multiplePureText(impSpec, module, spacer);
        }
        return ImportDeclarationTextHelper.rewriteTokenText(NodeModelUtils.findActualNodeFor((EObject)declaration), spacer, "InternalSemicolonInjectingParser.ASI");
    }

    private String namespacePureText(NamespaceImportSpecifier is, String module) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("import * as ");
        String _alias = is.getAlias();
        _builder.append(_alias);
        _builder.append(" from \"");
        _builder.append(module);
        _builder.append("\";");
        return _builder.toString();
    }

    private String defaultPureText(DefaultImportSpecifier is, String module) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("import ");
        String _name = is.getImportedElement().getName();
        _builder.append(_name);
        _builder.append(" from \"");
        _builder.append(module);
        _builder.append("\";");
        return _builder.toString();
    }

    private String namedPureText(NamedImportSpecifier is, String module, String spacer) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("import {");
        _builder.append(spacer);
        String _name = is.getImportedElement().getName();
        _builder.append(_name);
        String _alias = is.getAlias();
        boolean bl = _tripleNotEquals = _alias != null;
        if (_tripleNotEquals) {
            _builder.append(" as ");
            String _alias_1 = is.getAlias();
            _builder.append(_alias_1);
        }
        _builder.append(spacer);
        _builder.append("} from \"");
        _builder.append(module);
        _builder.append("\";");
        return _builder.toString();
    }

    private String multiplePureText(List<ImportSpecifier> impSpec, String module, String spacer) {
        ImportsSorter.sortByName(impSpec);
        DefaultImportSpecifier defImp = (DefaultImportSpecifier)IterableExtensions.head((Iterable)Iterables.filter(impSpec, DefaultImportSpecifier.class));
        NamespaceImportSpecifier nameImp = (NamespaceImportSpecifier)IterableExtensions.head((Iterable)Iterables.filter(impSpec, NamespaceImportSpecifier.class));
        Functions.Function1 _function = specifier -> Boolean.valueOf(specifier instanceof DefaultImportSpecifier) == Boolean.valueOf(false) && Boolean.valueOf(specifier instanceof NamespaceImportSpecifier) == Boolean.valueOf(false);
        Iterable rest = IterableExtensions.filter(impSpec, (Functions.Function1)_function);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)rest);
        boolean normalImports = !_isEmpty;
        String _xifexpression = null;
        if (defImp == null) {
            _xifexpression = "";
        } else {
            StringConcatenation _builder = new StringConcatenation();
            String _name = defImp.getImportedElement().getName();
            _builder.append(_name);
            _xifexpression = _builder.toString();
        }
        String defaultImport = _xifexpression;
        StringConcatenation _builder_1 = new StringConcatenation();
        if (defImp != null && nameImp != null) {
            _builder_1.append(", ");
        }
        String spacerDefName = _builder_1.toString();
        String _xifexpression_1 = null;
        if (nameImp == null) {
            _xifexpression_1 = "";
        } else {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("* as ");
            String _alias = nameImp.getAlias();
            _builder_2.append(_alias);
            _xifexpression_1 = _builder_2.toString();
        }
        String namespaceImport = _xifexpression_1;
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append("import ");
        _builder_3.append(defaultImport);
        _builder_3.append(spacerDefName);
        _builder_3.append(namespaceImport);
        if (normalImports) {
            _builder_3.append("{");
            _builder_3.append(spacer);
            boolean _hasElements = false;
            for (ImportSpecifier a : impSpec) {
                boolean _tripleNotEquals;
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder_3.appendImmediate((Object)", ", "");
                }
                String _name_1 = ((NamedImportSpecifier)a).getImportedElement().getName();
                _builder_3.append(_name_1);
                String _alias_1 = ((NamedImportSpecifier)a).getAlias();
                boolean bl = _tripleNotEquals = _alias_1 != null;
                if (!_tripleNotEquals) continue;
                _builder_3.append(" as ");
                String _alias_2 = ((NamedImportSpecifier)a).getAlias();
                _builder_3.append(_alias_2);
            }
            _builder_3.append(spacer);
            _builder_3.append("}");
        }
        _builder_3.append(" from \"");
        _builder_3.append(module);
        _builder_3.append("\";");
        return _builder_3.toString();
    }

    private static String rewriteTokenText(ICompositeNode node, String spacer, String ... ignoredSyntaxErrorIssues) {
        int _max = Math.max(node.getTotalLength(), 1);
        StringBuilder builder = new StringBuilder(_max);
        boolean hiddenSeen = false;
        boolean openingCurlySeen = false;
        boolean fixedASI = false;
        Iterable _leafNodes = node.getLeafNodes();
        for (ILeafNode leaf : _leafNodes) {
            boolean _isHiddenOrIgnoredSyntaxError;
            boolean _not;
            boolean _isIgnoredSyntaxErrorNode = UtilN4.isIgnoredSyntaxErrorNode((INode)leaf, (String[])new String[]{"InternalSemicolonInjectingParser.ASI"});
            if (_isIgnoredSyntaxErrorNode) {
                fixedASI = true;
            }
            boolean bl = _not = !(_isHiddenOrIgnoredSyntaxError = ImportDeclarationTextHelper.isHiddenOrIgnoredSyntaxError(leaf, ignoredSyntaxErrorIssues));
            if (_not) {
                boolean _equals_2;
                boolean _greaterThan;
                String text = leaf.getText();
                int _length = builder.length();
                boolean bl2 = _greaterThan = _length > 0;
                if (_greaterThan) {
                    if (openingCurlySeen) {
                        builder.append(spacer);
                    } else {
                        boolean _equals = Objects.equal((Object)"}", (Object)text);
                        if (_equals) {
                            builder.append(spacer);
                        } else {
                            boolean _equals_1 = Objects.equal((Object)",", (Object)text);
                            if (!_equals_1 && hiddenSeen) {
                                builder.append(" ");
                            }
                        }
                    }
                }
                openingCurlySeen = _equals_2 = Objects.equal((Object)"{", (Object)text);
                builder.append(text);
                hiddenSeen = false;
                continue;
            }
            hiddenSeen = true;
        }
        if (fixedASI) {
            builder.append(";");
        }
        return builder.toString();
    }

    private static boolean isHiddenOrIgnoredSyntaxError(ILeafNode leaf, String ... ignoredSyntaxErrorIssues) {
        return leaf.isHidden() || UtilN4.isIgnoredSyntaxErrorNode((INode)leaf, (String[])ignoredSyntaxErrorIssues);
    }
}

