/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Objects;
import org.eclipse.n4js.utils.SimpleParserException;

public class SimpleParser {

    protected static abstract class SimpleTokenizer<TokenType> {
        private final String data;
        private int pos;
        private int line;
        private int column;
        private final LinkedList<Token<TokenType>> tokenStack = new LinkedList();

        public SimpleTokenizer(String data) {
            this.data = Objects.requireNonNull(data);
            this.reset();
        }

        public void reset() {
            this.pos = 0;
            this.line = 0;
            this.column = 0;
            this.tokenStack.clear();
        }

        protected String getSubstring(TokenPosition position) {
            return this.getSubstring(position, this.getCurrentPosition());
        }

        protected String getSubstring(TokenPosition position, int endChar) {
            return this.data.substring(position.offset, endChar);
        }

        protected String getSubstring(int startChar) {
            return this.getSubstring(startChar, this.getCurrentPosition());
        }

        protected String getSubstring(int startChar, int endChar) {
            return this.data.substring(startChar, endChar);
        }

        protected Token<TokenType> createTokenFromSubstring(TokenType tokenType, TokenPosition position) {
            return this.createTokenFromSubstring(tokenType, position, this.getCurrentPosition());
        }

        protected Token<TokenType> createTokenFromSubstring(TokenType tokenType, TokenPosition startPosition, int endPosition) {
            return new Token<TokenType>(tokenType, startPosition, this.getTokenLength(startPosition, endPosition), this.getSubstring(startPosition, endPosition));
        }

        public Token<TokenType> nextToken() throws SimpleParserException {
            if (!this.tokenStack.isEmpty()) {
                return this.tokenStack.pop();
            }
            return this.readToken();
        }

        public void pushToken(Token<TokenType> token) {
            this.tokenStack.push(Objects.requireNonNull(token));
        }

        protected boolean hasPushedTokens() {
            return !this.tokenStack.isEmpty();
        }

        protected abstract Token<TokenType> readToken() throws SimpleParserException;

        protected Token<TokenType> readDelimitedStringToken(char delimiter, char escapeChar, TokenType tokenType) throws SimpleParserException {
            TokenPosition position = this.getTokenPosition();
            String attachment = this.readDelimitedString(delimiter, escapeChar);
            return new Token<TokenType>(tokenType, position, attachment.length(), attachment);
        }

        protected String readDelimitedString(char delimiter, char escapeChar) throws SimpleParserException {
            int startPos = this.getCurrentPosition();
            while (!this.eof()) {
                char p = this.getPreviousChar();
                char c = this.getCurrentCharAndAdvance();
                if (c != delimiter || p == escapeChar) continue;
                return this.data.substring(startPos, this.getCurrentPosition() - 1);
            }
            throw new SimpleParserException(this.line, this.column, "Expected '" + delimiter + "', but reached end of file");
        }

        protected Token<TokenType> readIntegerToken(TokenType tokenType) throws SimpleParserException {
            TokenPosition position = this.getTokenPosition();
            String attachment = this.readIntegerString();
            return new Token<TokenType>(tokenType, position, attachment.length(), attachment);
        }

        protected String readIntegerString() throws SimpleParserException {
            int startPos = this.getCurrentPosition();
            this.expectChar("+-0123456789");
            if (this.getCurrentChar() == '+' || this.getCurrentChar() == '-') {
                this.advance();
            }
            this.expectChar("0123456789");
            this.readWhile("0123456789");
            return this.data.substring(startPos, this.getCurrentPosition());
        }

        protected int readWhile(String include) {
            int count = 0;
            while (!this.eof() && include.indexOf(this.getCurrentChar()) != -1) {
                this.advance();
                ++count;
            }
            return count;
        }

        protected int readUntil(String delimiters) {
            int count = 0;
            while (!this.eof() && delimiters.indexOf(this.getCurrentChar()) == -1) {
                this.advance();
                ++count;
            }
            return count;
        }

        protected char getCurrentCharAndAdvance() {
            char c = this.getCurrentChar();
            this.advance();
            return c;
        }

        protected char getCurrentChar() {
            if (this.eof()) {
                return '\u0000';
            }
            return this.data.charAt(this.getCurrentPosition());
        }

        protected char getPreviousChar() {
            if (this.getCurrentPosition() > 0) {
                return this.data.charAt(this.getCurrentPosition() - 1);
            }
            return '\u0000';
        }

        protected char getNextChar() {
            if (this.getCurrentPosition() >= this.data.length() - 1) {
                return '\u0000';
            }
            return this.data.charAt(this.getCurrentPosition() + 1);
        }

        protected int getCurrentPosition() {
            return this.pos;
        }

        protected int getCurrentLine() {
            return this.line;
        }

        protected int getCurrentColumn() {
            return this.column;
        }

        protected TokenPosition getTokenPosition() {
            return new TokenPosition(this.line, this.column, this.pos);
        }

        protected int getTokenLength(TokenPosition position) {
            return this.getTokenLength(position, this.getCurrentPosition());
        }

        protected int getTokenLength(TokenPosition startPosition, int endPosition) {
            return endPosition - startPosition.offset;
        }

        protected void advance() {
            this.advance(1);
        }

        protected void advance(int count) {
            if (count < 0) {
                throw new IllegalArgumentException("Cannot advance backwards");
            }
            int i = 0;
            while (i < count) {
                if (this.getCurrentChar() == '\n') {
                    ++this.line;
                    this.column = 0;
                } else {
                    ++this.column;
                }
                ++this.pos;
                ++i;
            }
        }

        protected boolean eof() {
            return this.eof(this.getCurrentPosition());
        }

        protected boolean eof(int aPos) {
            return aPos >= this.data.length();
        }

        protected void throwIfEof() throws SimpleParserException {
            if (this.eof()) {
                throw new SimpleParserException(this.line, this.column, "Unexpected end of file");
            }
        }

        protected void unexpectedChar(char c) throws SimpleParserException {
            throw new SimpleParserException(this.line, this.column, "Unexpected character '" + c + "'");
        }

        protected void expectChar(char c) throws SimpleParserException {
            if (this.getCurrentChar() != c) {
                this.unexpectedChar(c);
            }
        }

        protected void expectChar(String s) throws SimpleParserException {
            if (s.indexOf(this.getCurrentChar()) == -1) {
                this.unexpectedChar(this.getCurrentChar());
            }
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            this.appendExcerpt("Data    : '...", "...'", result);
            result.append("Position: ").append(this.getCurrentPosition()).append("\n");
            result.append("Line    : ").append(this.getCurrentLine()).append("\n");
            result.append("Column  : ").append(this.getCurrentColumn()).append("\n");
            return result.toString();
        }

        private void appendExcerpt(String prefix, String suffix, StringBuilder result) {
            String excerptPrefix = this.sanitizeExcerpt(this.getExcerpt(this.getCurrentPosition(), -2));
            String excerptInfix = this.sanitizeExcerpt(this.getExcerpt(this.getCurrentPosition(), 1));
            String excerptSuffix = this.sanitizeExcerpt(this.getExcerpt(this.getCurrentPosition() + 1, 2));
            result.append(prefix).append(excerptPrefix).append(excerptInfix).append(excerptSuffix).append(suffix).append("\n");
            int i = 0;
            while (i < prefix.length() + excerptPrefix.length()) {
                result.append(" ");
                ++i;
            }
            result.append("^").append("\n");
        }

        private String getExcerpt(int position, int offset) {
            int minIndex = Math.min(position, position + offset);
            int maxIndex = Math.max(position, position + offset);
            int start = Math.max(minIndex, 0);
            int end = Math.min(maxIndex, this.data.length());
            return this.data.substring(start, end);
        }

        private String sanitizeExcerpt(String str) {
            return str.replaceAll("\n", "\\n").replaceAll("\t", "\\t");
        }
    }

    protected static class Token<TokenType>
    extends TokenPosition {
        public final TokenType type;
        public final int length;
        public final String data;

        public Token(TokenType type, TokenPosition position, int length, String data) {
            super(position);
            if (length < 0) {
                throw new IllegalArgumentException("Token length must not be negative");
            }
            this.type = Objects.requireNonNull(type);
            this.length = length;
            this.data = data;
        }

        public Token(TokenType type, TokenPosition position, int length) {
            this(type, position, length, null);
        }

        public Token(TokenType type, TokenPosition position) {
            this(type, position, 1);
        }

        @SafeVarargs
        public final Token<TokenType> expect(TokenType ... expected) throws SimpleParserException {
            if (this.hasType(expected)) {
                return this;
            }
            throw new SimpleParserException(this.line, this.column, "Expected " + Arrays.toString(expected) + ", but got " + this.toString());
        }

        @SafeVarargs
        public final boolean hasType(TokenType ... expected) {
            int i = 0;
            while (i < expected.length) {
                if (this.type == expected[i]) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public final int toInt() {
            return Integer.parseInt(this.data);
        }

        public final float toFloat() {
            return Float.parseFloat(this.data);
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append(this.type).append("[").append(this.offset).append(", ").append(this.length).append("]");
            if (this.data != null) {
                result.append(": ").append(this.data);
            }
            return result.toString();
        }
    }

    protected static class TokenPosition {
        public final int line;
        public final int column;
        public final int offset;

        public TokenPosition(int line, int column, int offset) {
            if (line < 0) {
                throw new IllegalArgumentException("Token line number must not be negative");
            }
            if (column < 0) {
                throw new IllegalArgumentException("Token column must not be negative");
            }
            if (offset < 0) {
                throw new IllegalArgumentException("Token offset must not be negative");
            }
            this.line = line;
            this.column = column;
            this.offset = offset;
        }

        protected TokenPosition(TokenPosition other) {
            Objects.requireNonNull(other);
            this.line = other.line;
            this.column = other.column;
            this.offset = other.offset;
        }
    }
}

