/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class SelectAllAction
extends Action {
    private StructuredViewer fViewer;

    public SelectAllAction() {
        super("selectAll");
        this.setText(SearchMessages.SelectAllAction_label);
        this.setToolTipText(SearchMessages.SelectAllAction_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.search.select_all_action_context");
    }

    public void setViewer(StructuredViewer viewer) {
        this.fViewer = viewer;
    }

    private void collectExpandedAndVisible(TreeItem[] items, List<TreeItem> result) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            result.add(item);
            if (item.getExpanded()) {
                this.collectExpandedAndVisible(item.getItems(), result);
            }
            ++n2;
        }
    }

    public void run() {
        if (this.fViewer == null || this.fViewer.getControl().isDisposed()) {
            return;
        }
        if (this.fViewer instanceof TreeViewer) {
            ArrayList<TreeItem> allVisible = new ArrayList<TreeItem>();
            Tree tree = ((TreeViewer)this.fViewer).getTree();
            this.collectExpandedAndVisible(tree.getItems(), allVisible);
            tree.setSelection(allVisible.toArray(new TreeItem[allVisible.size()]));
        } else if (this.fViewer instanceof TableViewer) {
            ((TableViewer)this.fViewer).getTable().selectAll();
            this.fViewer.setSelection(this.fViewer.getSelection());
        }
    }
}

