/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators;

import com.google.common.base.Joiner;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.ts.scoping.N4TSQualifiedNameProvider;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.n4js.validation.N4JSElementKeywordProvider;
import org.eclipse.n4js.validation.validators.N4JSClassValidator;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;

public class PolyfillValidatorFragment {
    private static final String PREFIX_LIST = ", ";
    @Inject
    N4JSElementKeywordProvider keywordProvider;
    @Inject
    ResourceDescriptionsProvider resourceDescriptionsProvider;
    @Inject
    IContainer.Manager containerManager;
    @Inject
    IQualifiedNameProvider qualifiedNameProvider;

    private void addIssue(PolyfillValidationState state, String msg, String issueCode) {
        state.host.addIssue(msg, (EObject)state.n4Class, (EStructuralFeature)N4JSPackage.Literals.N4_TYPE_DECLARATION__NAME, issueCode, new String[0]);
    }

    public boolean holdsPolyfill(N4JSClassValidator validator, N4ClassDeclaration n4Class) {
        boolean isStaticPolyFill = N4JSLanguageUtils.isStaticPolyfill((AnnotableElement)n4Class);
        if (isStaticPolyFill || N4JSLanguageUtils.isPolyfill((AnnotableElement)n4Class)) {
            PolyfillValidationState state = new PolyfillValidationState();
            state.host = validator;
            state.n4Class = n4Class;
            state.name = n4Class.getName();
            if (state.name == null || !(n4Class.getDefinedType() instanceof TClass)) {
                return true;
            }
            state.polyType = (TClass)n4Class.getDefinedType();
            if (state.polyType == null || state.name == null) {
                return true;
            }
            if (!this.holdsExpliciteExtends(state)) {
                return false;
            }
            Type superType = n4Class.getSuperClassRef().getDeclaredType();
            if (!(superType instanceof TClassifier)) {
                return true;
            }
            state.filledType = (TClassifier)superType;
            if (!isStaticPolyFill ? !this.holdPolyfillName(state) || !this.holdsProvidedByRuntime(state) || !this.holdsNoImplementsOrConsumes(state) || !this.holdsEqualModifiers(state) || !this.holdsEqualTypeVariables(state) || !this.holdsSinglePolyfillSource(state) : !this.holdPolyfillName(state) || !this.holdsFilledClassIsStaticPolyfillAware(state) || !this.holdsSameJavascriptVariant(state) || !this.holdsEqualModifiers(state) || !this.holdsEqualTypeVariables(state) || !this.holdsSinglePolyfillSource(state)) {
                return false;
            }
        }
        if (!isStaticPolyFill && N4JSLanguageUtils.isContainedInStaticPolyfillModule((AnnotableElement)n4Class)) {
            validator.addIssue(IssueCodes.getMessageForPOLY_STATIC_POLYFILL_MODULE_ONLY_FILLING_CLASSES(), (EObject)n4Class, (EStructuralFeature)N4JSPackage.Literals.N4_TYPE_DECLARATION__NAME, "POLY_STATIC_POLYFILL_MODULE_ONLY_FILLING_CLASSES", new String[0]);
            return false;
        }
        return true;
    }

    private boolean holdsFilledClassIsStaticPolyfillAware(PolyfillValidationState state) {
        if (!N4JSLanguageUtils.isContainedInStaticPolyfillAware((TAnnotableElement)state.filledType)) {
            String msg = IssueCodes.getMessageForCLF_POLYFILL_STATIC_FILLED_TYPE_NOT_AWARE(state.name);
            this.addIssue(state, msg, "CLF_POLYFILL_STATIC_FILLED_TYPE_NOT_AWARE");
            return false;
        }
        return true;
    }

    private boolean holdsSameJavascriptVariant(PolyfillValidationState state) {
        TModule fillerModule = state.polyType.getContainingModule();
        TModule filledModule = state.filledType.getContainingModule();
        if (fillerModule != null && filledModule != null && fillerModule.isN4jsdModule() != filledModule.isN4jsdModule()) {
            String fileExt = fillerModule.isN4jsdModule() ? "n4jsd" : "n4js";
            String msg = IssueCodes.getMessageForCLF_POLYFILL_STATIC_DIFFERENT_VARIANT(state.name, "." + fileExt);
            this.addIssue(state, msg, "CLF_POLYFILL_STATIC_DIFFERENT_VARIANT");
            return false;
        }
        return true;
    }

    private boolean holdsExpliciteExtends(PolyfillValidationState state) {
        ParameterizedTypeRef filledTypeRef = state.n4Class.getSuperClassRef();
        if (filledTypeRef == null) {
            String msg = IssueCodes.getMessageForCLF_POLYFILL_EXTEND_MISSING(state.name);
            this.addIssue(state, msg, "CLF_POLYFILL_EXTEND_MISSING");
            return false;
        }
        return true;
    }

    private boolean holdPolyfillName(PolyfillValidationState state) {
        boolean isGlobalPoly;
        if (!state.name.equals(state.filledType.getName())) {
            String msg = IssueCodes.getMessageForCLF_POLYFILL_DIFFERENT_NAME(state.name, state.filledType.getName());
            this.addIssue(state, msg, "CLF_POLYFILL_DIFFERENT_NAME");
            return false;
        }
        boolean isGlobalFilled = AnnotationDefinition.GLOBAL.hasAnnotation((TAnnotableElement)state.filledType);
        if (isGlobalFilled != (isGlobalPoly = AnnotationDefinition.GLOBAL.hasAnnotation((TAnnotableElement)state.polyType))) {
            String msg = IssueCodes.getMessageForCLF_POLYFILL_DIFFERENT_GLOBALS(state.name, isGlobalPoly ? "global" : "not global", isGlobalFilled ? "global" : "not global");
            this.addIssue(state, msg, "CLF_POLYFILL_DIFFERENT_GLOBALS");
            return false;
        }
        if (!isGlobalFilled) {
            TModule polyModule = state.polyType.getContainingModule();
            TModule filledModule = state.filledType.getContainingModule();
            if (polyModule != null && filledModule != null && !polyModule.getModuleSpecifier().equals(filledModule.getModuleSpecifier())) {
                String msg = IssueCodes.getMessageForCLF_POLYFILL_DIFFERENT_MODULE_SPECIFIER(state.name, polyModule.getModuleSpecifier(), filledModule.getModuleSpecifier());
                this.addIssue(state, msg, "CLF_POLYFILL_DIFFERENT_MODULE_SPECIFIER");
                return false;
            }
        }
        return true;
    }

    private boolean holdsProvidedByRuntime(PolyfillValidationState state) {
        if (!state.polyType.isProvidedByRuntime()) {
            String msg = IssueCodes.getMessageForCLF_POLYFILL_NOT_PROVIDEDBYRUNTIME(state.name);
            this.addIssue(state, msg, "CLF_POLYFILL_NOT_PROVIDEDBYRUNTIME");
            return false;
        }
        if (!state.filledType.isProvidedByRuntime()) {
            String msg = IssueCodes.getMessageForCLF_POLYFILL_FILLED_NOT_PROVIDEDBYRUNTIME(state.name);
            this.addIssue(state, msg, "CLF_POLYFILL_FILLED_NOT_PROVIDEDBYRUNTIME");
            return false;
        }
        return true;
    }

    private boolean holdsNoImplementsOrConsumes(PolyfillValidationState state) {
        if (!state.n4Class.getImplementedInterfaceRefs().isEmpty()) {
            String msg = IssueCodes.getMessageForCLF_POLYFILL_NO_IMPLEMENTS_OR_CONSUMES(state.name);
            this.addIssue(state, msg, "CLF_POLYFILL_NO_IMPLEMENTS_OR_CONSUMES");
            return false;
        }
        return true;
    }

    private boolean holdsEqualModifiers(PolyfillValidationState state) {
        boolean result = true;
        if (state.polyType.getTypeAccessModifier() != state.filledType.getTypeAccessModifier()) {
            String msg = IssueCodes.getMessageForCLF_POLYFILL_DIFFERENT_MODIFIER(state.name, this.keywordProvider.keyword(state.polyType.getTypeAccessModifier()), this.keywordProvider.keyword(state.filledType.getTypeAccessModifier()));
            this.addIssue(state, msg, "CLF_POLYFILL_DIFFERENT_MODIFIER");
            result = false;
        }
        result &= this.holdsEqualModifier(state, "abstract", state.polyType.isAbstract(), state.filledType.isAbstract());
        return result &= this.holdsEqualModifier(state, "@" + AnnotationDefinition.FINAL.name, state.polyType.isFinal(), state.filledType.isFinal());
    }

    private boolean holdsEqualModifier(PolyfillValidationState state, String modifierName, boolean poly, boolean filled) {
        if (poly != filled) {
            String msg = IssueCodes.getMessageForCLF_POLYFILL_DIFFERENT_MODIFIER(state.name, String.valueOf(poly ? "" : "non-") + modifierName, String.valueOf(filled ? "" : "non-") + modifierName);
            this.addIssue(state, msg, "CLF_POLYFILL_DIFFERENT_MODIFIER");
            return false;
        }
        return true;
    }

    private boolean holdsEqualTypeVariables(PolyfillValidationState state) {
        String typeVars2;
        String typeVars1 = Joiner.on((char)',').join(state.polyType.getTypeVars().stream().map(v -> v.getTypeAsString()).toArray());
        if (!typeVars1.equals(typeVars2 = Joiner.on((char)',').join(state.filledType.getTypeVars().stream().map(v -> v.getTypeAsString()).toArray()))) {
            String msg = IssueCodes.getMessageForCLF_POLYFILL_DIFFERENT_TYPEPARS(state.name);
            this.addIssue(state, msg, "CLF_POLYFILL_DIFFERENT_TYPEPARS");
            return false;
        }
        EList args = state.n4Class.getSuperClassRef().getTypeArgs();
        if (args.size() != state.polyType.getTypeVars().size()) {
            return true;
        }
        int i = state.polyType.getTypeVars().size() - 1;
        while (i >= 0) {
            String parString;
            TypeArgument arg = (TypeArgument)args.get(i);
            TypeVariable par = (TypeVariable)state.polyType.getTypeVars().get(i);
            String argString = arg.getTypeRefAsString();
            if (!argString.equals(parString = par.getName())) {
                String msg = IssueCodes.getMessageForCLF_POLYFILL_TYPEPARS_DIFFER_TYPEARGS(state.name, parString, argString);
                this.addIssue(state, msg, "CLF_POLYFILL_TYPEPARS_DIFFER_TYPEARGS");
                return false;
            }
            --i;
        }
        return true;
    }

    private boolean holdsSinglePolyfillSource(PolyfillValidationState state) {
        EList myPolyMember = state.polyType.getOwnedMembers();
        XtextResource res = (XtextResource)state.polyType.eResource();
        IResourceDescriptions index = this.resourceDescriptionsProvider.getResourceDescriptions((Resource)res);
        IContainer container = this.containerManager.getContainer(res.getResourceServiceProvider().getResourceDescriptionManager().getResourceDescription((Resource)res), index);
        Iterable iterEObj = container.getExportedObjects(TypesPackage.Literals.TCLASSIFIER, N4TSQualifiedNameProvider.getPolyfillFQN((TClassifier)state.filledType, (IQualifiedNameProvider)this.qualifiedNameProvider), false);
        LinkedListMultimap clashProviders = LinkedListMultimap.create();
        for (IEObjectDescription pivotObjectDescription : iterEObj) {
            EObject eob = pivotObjectDescription.getEObjectOrProxy();
            if (eob.eIsProxy()) {
                eob = EcoreUtil.resolve((EObject)eob, (Resource)res);
            }
            if (eob == state.polyType) continue;
            EList pivotPolyMember = ((TClassifier)eob).getOwnedMembers();
            ListMultimap<TMember, TMember> clashing = this.findClashingMembersByName((EList<TMember>)myPolyMember, (EList<TMember>)pivotPolyMember);
            for (TMember myMember : clashing.keySet()) {
                clashProviders.put((Object)myMember, (Object)((TMember)clashing.get((Object)myMember).get(0)).getContainingModule());
            }
        }
        ArrayList sortedMembers = new ArrayList(clashProviders.keySet());
        Collections.sort(sortedMembers, (m1, m2) -> m1.getName().compareTo(m2.getName()));
        for (TMember myMember : sortedMembers) {
            int lastPrefix_idx;
            String uris = Stream.concat(Stream.of(myMember.getContainingModule()), clashProviders.get((Object)myMember).stream()).map(u -> u.getQualifiedName().toString()).sorted().reduce("", (a, b) -> String.valueOf(a) + PREFIX_LIST + b);
            if (uris.startsWith(PREFIX_LIST)) {
                uris = uris.substring(PREFIX_LIST.length());
            }
            if ((lastPrefix_idx = uris.lastIndexOf(PREFIX_LIST)) >= 0) {
                StringBuffer sb = new StringBuffer(uris);
                uris = sb.replace(lastPrefix_idx, lastPrefix_idx + PREFIX_LIST.length(), " and ").toString();
            }
            String memberAxis = String.valueOf(myMember.getContainingType().getName()) + "." + myMember.getName();
            String msg = IssueCodes.getMessageForCLF_POLYFILL_MULTIPOLYFILLS_MEMBER_CONFLICT(uris, memberAxis);
            state.host.addIssue(msg, myMember.getAstElement(), (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, "CLF_POLYFILL_MULTIPOLYFILLS_MEMBER_CONFLICT", new String[0]);
        }
        return true;
    }

    private ListMultimap<TMember, TMember> findClashingMembersByName(EList<TMember> myPolyMember, EList<TMember> pivotPolyMember) {
        LinkedListMultimap ret = LinkedListMultimap.create();
        for (TMember my : myPolyMember) {
            String myName = my.getName();
            if (myName == null) continue;
            for (TMember other : pivotPolyMember) {
                String otherName = other.getName();
                if (!myName.equals(otherName)) continue;
                ret.put((Object)my, (Object)other);
            }
        }
        return ret;
    }

    private static class PolyfillValidationState {
        N4JSClassValidator host;
        N4ClassDeclaration n4Class;
        TClass polyType;
        TClassifier filledType;
        String name;

        private PolyfillValidationState() {
        }
    }
}

